//============================================================
// Program:		WorstGameEver
// Description:	Worthless game created for no good reason
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		4/20/01
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

//RUNNING_FROM_COMPILER is defined in the preprocessor settings

#include "GameFrame.h"

GameFrame WGE("WorstGameEver", 1);
CGFCamera Player;
CGFSolarSystem SolarSystem;
CGFHUD HUD;

D3DVIEWPORT8 ViewPort;
D3DVIEWPORT8 ZoomViewPort;

void InitializeGame(void);
void MainLoop(void);
void DestroyGame(void);

void SetupWeapons(void);
void SetupHUD(void);

LPDIRECT3DVERTEXBUFFER8 VertexBuffer = NULL;

INT WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nShowCmd)
{
	char path[MAX_PATH+256];
	srand(GetTickCount());

	#ifdef RUNNING_FROM_COMPILER
	sprintf(path, "graphics_mode.ini");
	#else
	sprintf(path, "%s%s", WGE.LocalPath, "graphics_mode.ini");
	#endif

	WGE.BeginDirectX(hInst, path, "WorstGameEver");
	WGE.D3DDevice->SetRenderState(D3DRS_AMBIENT, D3DCOLOR_RGBA(10, 10, 10, 0));
	WGE.SetMouseSmoothing(1);
	
	ViewPort.X = 0;
	ViewPort.Y = 0;
	ViewPort.MinZ = 0;
	ViewPort.MaxZ = 1.0f;
	ViewPort.Width = WGE.Width;
	ViewPort.Height = WGE.Height;

	#ifdef RUNNING_FROM_COMPILER
	sprintf(path, "%s..\\Data\\Sounds", WGE.LocalPath);
	#else
	sprintf(path, "%sData\\Sounds", WGE.LocalPath);
	#endif

	WGE.Sound.BeginDirectSound(&WGE, path, 50);

	char path1[MAX_PATH + 256];
	char path2[MAX_PATH + 256];
	
	#ifdef RUNNING_FROM_COMPILER
	sprintf(path1, "%s..\\Data\\Models", WGE.LocalPath);
	sprintf(path2, "%s..\\Data\\Textures", WGE.LocalPath);
	#else
	sprintf(path1, "%sData\\Models", WGE.LocalPath);
	sprintf(path2, "%sData\\Textures", WGE.LocalPath);
	#endif

	WGE.SmartLoader.SetSearchPaths(path1, path2);

	InitializeGame();
	WGE.StartMainLoop(&MainLoop);
	DestroyGame();

	WGE.DestroyDirectX();

	return 0;
}

void InitializeGame(void)
{
	int index = 0;
	list<int> tmp;
	//old mouse 0.18

	char path[MAX_PATH+256];	
	#ifdef RUNNING_FROM_COMPILER
	sprintf(path, "key_bindings.ini");
	#else
	sprintf(path, "%s%s", WGE.LocalPath, "key_bindings.ini");
	#endif

	Player.Initialize(&WGE);
	Player.LoadKeyBindings(path);
	Player.Y = 500.0f;
	Player.Z = 20000.0f;
	Player.Yaw = PI + PI / 6.0f;
	Player.EnableGravity(NULL);
	
	WGE.ParticleSystem.SetCamera(&Player);
	SolarSystem.Initialize(&WGE, &Player);
	SolarSystem.EnableLighting(1);

	WGE.Sound.AddSound("engage_warp.wav");	
	WGE.Sound.AddSound("atwarp.wav");	
	WGE.Sound.AddSound("dropping_warp.wav");
	WGE.Sound.AddSound("thrust.wav");
	WGE.Sound.AddSound("thrustsm.wav");
	index = WGE.Sound.AddSound("ambient.wav");

	WGE.Sound.SetRepeats(index);
	WGE.Sound.PlaySound(index);

	SetupWeapons();
	SetupHUD();

	#ifdef RUNNING_FROM_COMPILER
	sprintf(path, "solar_system.ini");
	#else
	sprintf(path, "%s%s", WGE.LocalPath, "solar_system.ini");
	#endif
	SolarSystem.LoadSolarSystem(path);

	//SolarSystem.ScaleSolarSystem(10.0f);
}


void MainLoop(void)
{	
	D3DXMATRIX ScaleMat;
	char msg[100];
	
	WGE.D3DDevice->SetViewport(&ViewPort);
	WGE.D3DDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER | D3DCLEAR_TARGET, D3DCOLOR_ARGB(0,0,0,0), 1.0f, 0 );
    WGE.D3DDevice->BeginScene();
	
	WGE.UpdateKeyInfo();
	WGE.UpdateMouseInfo();
	if(WGE.KEYDOWN(DIK_ESCAPE)) WGE.StopMainLoop();

	Player.UpdateCamera();
	Player.DoCamera();

	SolarSystem.Update();
	WGE.ParticleSystem.Update();
	HUD.Update();

	SolarSystem.Render();
	WGE.ParticleSystem.Render();
	HUD.Render();

	WGE.FontLib.BeginFont(0);
	sprintf(msg, "FPS: %.3f", WGE.GetFPS());
	WGE.FontLib.DrawText(msg, 10, 10, D3DCOLOR_ARGB(255, 200, 200, 200));
	sprintf(msg, "%s    Ammo: %d", Player.Arsenal.GetPrimaryName(), Player.Arsenal.GetPrimaryAmmoCount());
	WGE.FontLib.DrawText(msg, 10, WGE.Height - 40, D3DCOLOR_ARGB(255, 100, 100, 180));
	sprintf(msg, "%s    Ammo: %d", Player.Arsenal.GetSecondaryName(), Player.Arsenal.GetSecondaryAmmoCount());
	WGE.FontLib.DrawText(msg, 10, WGE.Height - 20, D3DCOLOR_ARGB(255, 100, 100, 180));
	sprintf(msg, "%.0fx", Player.ZoomFactor);
	WGE.FontLib.DrawText(msg, ZoomViewPort.X, ZoomViewPort.Height, D3DCOLOR_ARGB(255, 200, 200, 200));
	WGE.FontLib.EndFont(0);

	WGE.D3DDevice->SetViewport(&ZoomViewPort);
	D3DXMatrixScaling(&ScaleMat, Player.ZoomFactor, Player.ZoomFactor, 1.0f);
	Player.DoCamera(&ScaleMat);

	SolarSystem.EnableLighting(0);
	SolarSystem.Render();
	SolarSystem.EnableLighting(1);

	WGE.D3DDevice->EndScene();
	WGE.Present();
}


void DestroyGame(void)
{

}


void SetupWeapons(void)
{
	list<int> tmp;
	PARTICLE_TYPE type;
	WEAPON weapon;

	WGE.SmartLoader.EnqueueModelFile("weapon_plasma.3ds");
	WGE.SmartLoader.EnqueueModelFile("weapon_ringfire.3ds");
	WGE.SmartLoader.EnqueueModelFile("weapon_heavycannon.3ds");
	WGE.SmartLoader.EnqueueModelFile("weapon_flamer.3ds");

	if(WGE.TextureLib.IsCompressionEnabled())
	{
		WGE.TextureLib.EnableTextureCompression(0);
		WGE.SmartLoader.ProcessModelQueue(&WGE, 15000);
		WGE.TextureLib.EnableTextureCompression(1);
	}
	else
	{
		WGE.SmartLoader.ProcessModelQueue(&WGE, 15000);
	}

	int index = 0;
	memset(&type, 0, sizeof(PARTICLE_TYPE));
	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	type.IsAlphaActive = 1;
	type.IsBillboardingActive = 1;
	type.IsColorActive = 1;
	type.Extra1 = 2.0;
	type.full_modifier = RollSpinModifier;
	type.ObjLibIndex = tmp.front();
	index = WGE.ParticleSystem.AddParticleType(&type);

	memset(&weapon, 0, sizeof(WEAPON));
	sprintf(weapon.Name, "Plasma Cannon");
	weapon.Color = D3DCOLOR_ARGB(255, 140,160,230);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_plasma.wav");
	weapon.MaxAge = 150.0f;
	weapon.Speed = 50.0f;
	weapon.RoundsRemaining = 1000;
	weapon.SecondsPerRound = 0.1f;
	weapon.ParticleType = index;
	Player.Arsenal.AddPrimaryWeapon(&weapon);

	weapon.SecondsPerRound = 0.1f;
	sprintf(weapon.Name, "Alt Plasma Cannon");
	weapon.ShiftX = -1.0f;
	weapon.modifier = AlternateSidesModifier;
	Player.Arsenal.AddSecondaryWeapon(&weapon);



	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	type.ObjLibIndex = tmp.front();
	type.IsColorActive = 1;
	index = WGE.ParticleSystem.AddParticleType(&type);

	memset(&weapon, 0, sizeof(WEAPON));
	sprintf(weapon.Name, "Ringfire Cannon");
	weapon.Color = D3DCOLOR_ARGB(255, 200, 200, 255);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_plasma.wav");
	weapon.MaxAge = 150.0f;
	weapon.Speed = 50.0f;
	weapon.RoundsRemaining = 1000;
	weapon.SecondsPerRound = 0.06f;
	weapon.ParticleType = index;
	Player.Arsenal.AddPrimaryWeapon(&weapon);
	
	sprintf(weapon.Name, "Alt Ringfire Cannon");
	weapon.Color = D3DCOLOR_ARGB(255, 255, 255, 10);
	weapon.SecondsPerRound = 0.01f;
	weapon.ShiftX = -1.0f;
	weapon.modifier = AlternateSidesModifier;
	Player.Arsenal.AddSecondaryWeapon(&weapon);



	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	type.ObjLibIndex = tmp.front();
	type.IsColorActive = 1;
	index = WGE.ParticleSystem.AddParticleType(&type);

	memset(&weapon, 0, sizeof(WEAPON));
	sprintf(weapon.Name, "Heavy Cannon");
	weapon.Color = D3DCOLOR_ARGB(255, 255, 255, 180);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_heavycannon.wav");
	weapon.MaxAge = 150.0f;
	weapon.Speed = 70.0f;
	weapon.RoundsRemaining = 2000;
	weapon.SecondsPerRound = 0.01f;
	weapon.ParticleType = index;
	weapon.Extra1 = 1.1f;
	weapon.Extra2 = 1.0f;
	weapon.modifier = RotateModifier;
	Player.Arsenal.AddPrimaryWeapon(&weapon);
	
	sprintf(weapon.Name, "Corkscrew");
	weapon.Color = D3DCOLOR_ARGB(255, 200, 200, 255);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_corkscrew.wav");
	weapon.Speed = 100.0f;
	weapon.SecondsPerRound = 0.01f;
	weapon.Extra1 = 0.2f;
	weapon.modifier = RotateModifier;
	Player.Arsenal.AddSecondaryWeapon(&weapon);



	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	type.ObjLibIndex = tmp.front();
	type.IsColorActive = 1;
	type.Extra1 = 2.0f;
	type.full_modifier = RollSpinModifier;
	index = WGE.ParticleSystem.AddParticleType(&type);

	memset(&weapon, 0, sizeof(WEAPON));
	sprintf(weapon.Name, "Flamer A");
	weapon.Color = D3DCOLOR_ARGB(255, 255, 255, 255);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_heavycannon.wav");//
	weapon.MaxAge = 150.0f;
	weapon.Speed = 100.0f;
	weapon.RoundsRemaining = 2000;
	weapon.SecondsPerRound = 0.01f;
	weapon.ParticleType = index;
	weapon.Extra1 = 1.7f;
	weapon.Extra2 = 1.0f;
	weapon.modifier = ShiftXModifier;
	Player.Arsenal.AddPrimaryWeapon(&weapon);

	sprintf(weapon.Name, "Flamer B");
	weapon.Color = D3DCOLOR_ARGB(255, 255, 255, 255);
	weapon.FireSoundLibIndex = WGE.Sound.AddSound("weapon_heavycannon.wav");//
	weapon.Speed = 105.0f;
	weapon.SecondsPerRound = 0.01f;
	weapon.Extra1 = 1.7f;
	weapon.modifier = ShiftYModifier;
	Player.Arsenal.AddSecondaryWeapon(&weapon);
}

void SetupHUD(void)
{
	list<int> tmp;

	HUD.Initialize(&WGE, &Player, 50);
	HUD.SetSolarSystem(&SolarSystem);

	ZoomViewPort.MinZ = 0;
	ZoomViewPort.MaxZ = 0;
	ZoomViewPort.Width = (int)(21.09375f * HUD.XPPU);
	ZoomViewPort.Height = (int)(26.36718f * HUD.YPPU * WGE.H2WRatio);
	ZoomViewPort.X = WGE.Width - ZoomViewPort.Width;
	ZoomViewPort.Y = 0;

	WGE.SmartLoader.EnqueueModelFile("crosshair.3ds");
	WGE.SmartLoader.EnqueueModelFile("HUDPlanetScope.3ds");
	WGE.SmartLoader.EnqueueModelFile("HUDSphere.3ds");
	WGE.SmartLoader.EnqueueModelFile("HUDZoomBorder.3ds");  
	WGE.SmartLoader.EnqueueModelFile("HUDBrightnessOverlay.3ds");

	if(WGE.TextureLib.IsCompressionEnabled())
	{
		WGE.TextureLib.EnableTextureCompression(0);
		WGE.SmartLoader.ProcessModelQueue(&WGE, 15000);
		WGE.TextureLib.EnableTextureCompression(1);
	}
	else
	{
		WGE.SmartLoader.ProcessModelQueue(&WGE, 15000);
	}
	
	HUD_OBJECT hud_obj;
	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	memset(&hud_obj, 0, sizeof(HUD_OBJECT));
	hud_obj.LibraryIndex = tmp.front();		
	hud_obj.Extra1 = 2.0f;
	hud_obj.Modifier = RollSpinModifier;
	HUD.AddHUDObject(&hud_obj);

	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	memset(&hud_obj, 0, sizeof(HUD_OBJECT));
	hud_obj.LibraryIndex = tmp.front();		
	hud_obj.CustomRender = PlanetLocationModifier;
	hud_obj.Extra1 = 0.18f;
	hud_obj.Modifier = GlowModifier;
	hud_obj.IsColorActive = 1;
	HUD.AddHUDObject(&hud_obj);

	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	memset(&hud_obj, 0, sizeof(HUD_OBJECT));
	hud_obj.LibraryIndex = tmp.front();	
	hud_obj.X = -42.0f;
	hud_obj.Y =  40.0f;
	hud_obj.Flags = HUD_DONT_BILLBOARD_OBJECT;
	HUD.AddHUDObject(&hud_obj);

	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	memset(&hud_obj, 0, sizeof(HUD_OBJECT));
	hud_obj.LibraryIndex = tmp.front();	
	hud_obj.X = 41.05f;
	hud_obj.Y = 41.05f;
	HUD.AddHUDObject(&hud_obj);

	WGE.SmartLoader.DequeProcessedIndices(&tmp);
	memset(&hud_obj, 0, sizeof(HUD_OBJECT));
	hud_obj.LibraryIndex = tmp.front();	
	hud_obj.X = 0.0f;
	hud_obj.Y = 0.0f;
	hud_obj.IsColorActive = 1;
	hud_obj.Color = D3DCOLOR_ARGB(255, 0, 0, 0);
	hud_obj.Modifier = SunLookModifier;
	HUD.AddHUDObject(&hud_obj);
}
