//============================================================
// Program:		CGFWeaponSystem
// Description:	Class for handling weapons
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_WEAPON_SYSTEM_
#define _CGF_WEAPON_SYSTEM_

#pragma warning(disable:4995)
#include <d3dx8.h>
#include "GameFrameParticleSystem.h"

class CGFCamera;
class CGFParticleSystem;
class GameFrame;
class CGFWeaponSystem;

struct WEAPON
{
/****Particle Settings*******/
	int ParticleType;
	D3DXCOLOR Color;
	float DeltaColor;
	float MaxAge;
	float Speed;
/****************************/

	char Name[100];
	float SecondsPerRound;
	int RoundsRemaining;
	int LeaveTrail;
	float LifePoints;
	float BlastRadiusSq;
	float BlastFalloffSq;
	float DirectDamage;
	int FireSoundLibIndex;
	int HitSoundLibIndex;
	float ShiftX, ShiftY, ShiftZ;	//Shift the launch port so it's not at camera<0,0,0>

	float LastShotTime;

	float Extra1, Extra2, Extra3;
	void (* modifier)(WEAPON *weapon, GameFrame *gfparent);		//Called each time Fire() is called
};

/*****************Modifier Prototypes*****************************************/
void AlternateSidesModifier(WEAPON *weapon, GameFrame *gfparent);
void RotateModifier(WEAPON *weapon, GameFrame *gfparent);
void ShiftXModifier(WEAPON *weapon, GameFrame *gfparent);
void ShiftYModifier(WEAPON *weapon, GameFrame *gfparent);
/*****************************************************************************/

class CGFWeaponSystem
{
public:
	CGFWeaponSystem();
	~CGFWeaponSystem();

	int  Initialize(GameFrame *gfparent, CGFCamera *camera, int num_nodes);
	int  AddPrimaryWeapon(WEAPON *obj);
	int  AddSecondaryWeapon(WEAPON *obj);
	void Destroy(void);

	void SetCurrentPrimary(int index)		{ CurrentPrimary = index; }
	void SetCurrentSecondary(int index)		{ CurrentSecondary = index; }
	void NextPrimary(void);
	void PreviousPrimary(void);
	void NextSecondary(void);
	void PreviousSecondary(void);

	void FirePrimary();
	void FireSecondary();

	int		GetPrimaryAmmoCount(void)		{ return PrimaryWeapons[CurrentPrimary].RoundsRemaining; }
	char*	GetPrimaryName(void)			{ return PrimaryWeapons[CurrentPrimary].Name; }
	int		GetSecondaryAmmoCount(void)		{ return SecondaryWeapons[CurrentSecondary].RoundsRemaining; }
	char*	GetSecondaryName(void)			{ return SecondaryWeapons[CurrentSecondary].Name; }

private:

	GameFrame	*GFParent;
	CGFCamera	*Camera;
	
	int			CurrentPrimary;
	int			CurrentSecondary;

	int			NumPrimary;
	int			NumPrimaryUsed;
	WEAPON		*PrimaryWeapons;

	int			NumSecondary;
	int			NumSecondaryUsed;
	WEAPON		*SecondaryWeapons;
};

#endif
