//============================================================
// Program:		CGFVertexLibrary
// Description:	Class for storing vertex buffers
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_VERTEX_LIBRARY_
#define _GAME_FRAME_VERTEX_LIBRARY_

#pragma warning(disable:4995)
#include <d3dx8.h>

class GameFrame;
class CGFVertexLibrary
{
public:

	CGFVertexLibrary();
	~CGFVertexLibrary();
	
	int Initialize(GameFrame *gfparent, int num_nodes);
	void Destroy(void);
	int AddVertexBuffer(int num_vertices, DWORD vertex_size, DWORD fvf);  //Returns index if successful else -1

	_inline const	int&	GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&	GetLibNumUsed(void)		{ return NumUsed; }
	_inline const	int&	GetNum(int index)		{ return Library[index].NumVertices; }
	_inline const	DWORD&	GetFVF(int index)		{ return Library[index].FVF; }
	_inline const	DWORD&	GetSize(int index)		{ return Library[index].VertexSize; }
	_inline			LPDIRECT3DVERTEXBUFFER8& GetBuffer(int index)	{ return (Library[index].Vertices); }
	_inline			LPDIRECT3DVERTEXBUFFER8& operator[](int index)	{ return (Library[index].Vertices); }
	_inline int		LockBuffer(int index, BYTE **vertices) { return (Library[index].Vertices)->Lock(0, 0, vertices, 0); }
	_inline int		UnlockBuffer(int index) {return (Library[index].Vertices)->Unlock(); }

private:

	GameFrame* GFParent;

	struct VBNODE
	{
		LPDIRECT3DVERTEXBUFFER8 Vertices;
		int NumVertices;
		DWORD FVF;
		DWORD VertexSize;
	};

	VBNODE *Library;
	int NumNodes;
	int NumUsed;
};

#endif
