//============================================================
// Program:		CGFTextureLibrary
// Description:	Class for storing textures
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_TEXTURE_LIBRARY_
#define _GAME_FRAME_TEXTURE_LIBRARY_

#pragma warning(disable:4995)
#include <d3dx8.h>

class GameFrame;
class CGFTextureLibrary
{
public:

	CGFTextureLibrary();
	~CGFTextureLibrary();
	
	int Initialize(GameFrame *gfparent, int num_nodes);
	void Destroy(void);
	void EnableTextureCompression(int flag)		{ UseCompressedTextures = flag; }
	int  IsCompressionEnabled(void)				{ return UseCompressedTextures; }
	int AddTexture(char *file);		//Returns index if successful else -1
	int FindTexture(char *name);	//Returns index if successful else -1

	_inline const	int&	GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&	GetLibNumUsed(void)		{ return NumUsed; }
	_inline const	LPDIRECT3DTEXTURE8& GetTexture(int index)	{ return Library[index].Texture; }
	_inline const	LPDIRECT3DTEXTURE8& operator[](int index)	{ return Library[index].Texture; }

private:

	GameFrame* GFParent;

	struct TXNODE
	{
		LPDIRECT3DTEXTURE8 Texture;
		char TextureName[256];
	};

	int UseCompressedTextures;

	TXNODE *Library;
	int NumNodes;
	int NumUsed;
};

#endif