//============================================================
// Program:		CGFSmartLoader
// Description:	Builds Optimal Sized Vertex Buffers
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _SMARTLOADER_H_
#define _SMARTLOADER_H_

#pragma warning(disable:4995)

#include <d3dx8.h>
#include <vector.h>
#include <list.h>
#include "3DSLoader.h"

#define D3DFVF_COLOREDLITVERTEX (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_NORMAL)
struct COLOREDLITVERTEX
{
	D3DXVECTOR3 position;  
	D3DXVECTOR3 normal;
	D3DCOLOR    diffuse;
};

#define D3DFVF_COLOREDTEXTUREDLITVERTEX (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 | D3DFVF_NORMAL)
struct COLOREDTEXTUREDLITVERTEX
{
	D3DXVECTOR3 position;  
	D3DXVECTOR3 normal;
	D3DCOLOR    diffuse;
	FLOAT		tu, tv;
};

class GameFrame;
class CGFSmartLoader
{
public:

	CGFSmartLoader();
	~CGFSmartLoader();

	void SetSearchPaths(char *model_path, char *texture_path);
	int EnqueueModelFile(char *file);
	int ProcessModelQueue(GameFrame *gfparent, int desired_vb_size);
	int DequeProcessedIndices(list< int > *indices);

	_inline int GetModelQueueSize(void) { return (int)Indices.size(); }

private:

	GameFrame *GFParent;

	char ModelPath[MAX_PATH];
	char TexturePath[MAX_PATH];

	list< list< int > > Indices;	//Object Lib Indices
	list< char * > ModelFiles;		//Raw Model Data
};




#endif