#ifndef _CGF_SKY_
#define _CGF_SKY_

#include "GameFrame.h"
#include <list.h>

#define RENDER_TEXTURED		1

class CGFCamera;
class CGFSky
{
public:
	CGFSky();
	~CGFSky();

	void Initialize(GameFrame *gfparent, list<int> &obj_lib_indices);
	void Reset(void);
	void Destroy(void);

	void LatchToCamera(CGFCamera *camera);
	void SetRenderFlags(DWORD flags);
	void Move(DWORD type, float speed);
	void Rotate(DWORD type, float speed);
	void Update(void);
	int  Render(void);

	float FrictionDrag;

	float X, Y, Z;
	float XVec, YVec, ZVec;

	float Yaw, Pitch, Roll;
	float YawVec, PitchVec, RollVec; 

private:

	GameFrame	*GFParent;
	CGFCamera	*Camera;
	
	int			NumLibraryIndices;
	int			*LibraryIndices;

	DWORD		RenderFlags;

	D3DXVECTOR3 Up_Vector; 
	D3DXVECTOR3 Right_Vector; 
	D3DXVECTOR3 Look_Vector;
};

#endif
