//============================================================
// Program:		CGFObjectLibrary
// Description:	Class for storing objects
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_OBJECT_LIBRARY_
#define _GAME_FRAME_OBJECT_LIBRARY_

#pragma warning(disable:4995)
#include <d3dx8.h>

struct OBJNODE
{
	//Geometry Location
	int VertexLibraryIndex;
	int StartVertex;
	int PrimitiveCount;
	D3DPRIMITIVETYPE PrimitiveType;

	//Texture Location
	int TextureLibraryIndex;

	//Material Location
	int MaterialLibraryIndex;

	//Collision Detection Radius 
	float Radius;

	//Object Center W.R.T. Collision Detection Radius
	D3DXVECTOR3 Center;

	//Collision Detection Box Corners
	D3DXVECTOR3 BoxMin;
	D3DXVECTOR3 BoxMax;

	char ObjectName[256];
};

class GameFrame;
class CGFObjectLibrary
{
public:

	CGFObjectLibrary();
	~CGFObjectLibrary();
	
	int Initialize(GameFrame *gfparent, int num_nodes);
	void Destroy(void);
	int AddObject(OBJNODE *object);  //Returns index if successful else -1
	int FindObject(char *name);		 //Returns index if successful else -1

	_inline const	int&		GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&		GetLibNumUsed(void)		{ return NumUsed; }
	_inline			OBJNODE*	GetObject(int index)	{ return &(Library[index]); }
	_inline			OBJNODE*	operator[](int index)	{ return &(Library[index]); }

private:

	GameFrame* GFParent;

	OBJNODE *Library;
	int NumNodes;
	int NumUsed;
};

#endif