//============================================================
// Program:		CGFMaterialLibrary
// Description:	Material storage class
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_MATERIAL_LIBRARY_
#define _GAME_FRAME_MATERIAL_LIBRARY_

#pragma warning(disable:4995)
#include <d3dx8.h>

class GameFrame;
class CGFMaterialLibrary
{
public:

	CGFMaterialLibrary();
	~CGFMaterialLibrary();
	
	int Initialize(GameFrame *gfparent, int num_nodes);
	void Destroy(void);
	int AddMaterial(D3DMATERIAL8 *material);  //Returns index if successful else -1

	_inline const	int&	GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&	GetLibNumUsed(void)		{ return NumUsed; }
	_inline const	D3DMATERIAL8& GetMaterial(int index)	{ return Library[index].Material; }
	_inline const	D3DMATERIAL8& operator[](int index)	{ return Library[index].Material; }

private:

	GameFrame* GFParent;

	struct MTNODE
	{
		D3DMATERIAL8 Material;
	};

	MTNODE *Library;
	int NumNodes;
	int NumUsed;
};

#endif