//============================================================
// Program:		CGFHUD
// Description:	Heads up display
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_HUD_
#define _CGF_HUD_

#pragma warning(disable:4995)
#include <list.h>
#include <d3dx8.h>

class CGFCamera;
class GameFrame;
class CGFSolarSystem;
class CGFHUD;

#define HUD_DONT_BILLBOARD_OBJECT	 1

struct RENDER_INFO
{
	float X, Y, Z;
	float Yaw, Pitch, Roll;
};

struct HUD_OBJECT
{
	float X, Y, Z;
	float Yaw, Pitch, Roll;
	int LibraryIndex;

	void (*Modifier)(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
	void (*Modifier2)(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
	
	//If 1 is returned, the normal renderer is called, otherwise it is skipped
	int (*CustomRender)(CGFHUD *hud, HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);

	DWORD Flags;
	float Extra1, Extra2, Extra3;

	int	IsColorActive;
	D3DXCOLOR Color;

	RENDER_INFO data;	//Ignore this parameter. For private use.
};

/*****************Modifier Prototypes*****************************************/
void YawSpinModifier(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
void PitchSpinModifier(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
void RollSpinModifier(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
void GlowModifier(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
void SunLookModifier(HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
int PlanetLocationModifier(CGFHUD *hud, HUD_OBJECT *obj, GameFrame *gfparent, CGFCamera *camera, CGFSolarSystem *system);
/*****************************************************************************/

class CGFHUD
{	
public:

	friend HUD_OBJECT;

	CGFHUD();
	~CGFHUD();

	int  Initialize(GameFrame *gfparent, CGFCamera *camera, int num_nodes);
	void SetSolarSystem(CGFSolarSystem *system)  { SolarSystem = system; }
	int  AddHUDObject(HUD_OBJECT *obj);
	void Destroy(void);

	void Update(void);
	int  Render(void);

	float XPPU, YPPU;

private:

	GameFrame		*GFParent;
	CGFCamera		*Camera;
	CGFSolarSystem	*SolarSystem;
	
	int				NumHUDObjects;
	int				NumUsed;
	HUD_OBJECT		*HUDObjects;
};

#endif
