//============================================================
// Program:		CGFFontLibrary
// Description:	Simple font wrapper
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_FONT_LIBRARY_
#define _GAME_FRAME_FONT_LIBRARY_

#pragma warning(disable:4995)
#include <d3dx8.h>

class GameFrame;
class CGFFontLibrary
{
public:

	CGFFontLibrary();
	~CGFFontLibrary();

	int Initialize(GameFrame *gfparent, int num_nodes);
	void Destroy(void);

	void OnLostDevice(void);
	void OnResetDevice(void);

	int AddFont(HFONT font, int width, int height);		//Returns index if successful else -1
	void BeginFont(int index);
	void DrawText(char *buffer, RECT *text_rect, DWORD color, 
				  DWORD flags = DT_LEFT | DT_WORDBREAK);
	void DrawText(char *buffer, int x, int y, DWORD color);
	void EndFont(int index);

	_inline const	int&	GetLibNumNodes(void)	{ return NumNodes; }
	_inline const	int&	GetLibNumUsed(void)		{ return NumUsed; }

private:

	GameFrame* GFParent;

	struct FONT_NODE
	{
		ID3DXFont *Font;
		int Width, Height;
	};

	int						StasisFlag;

	FONT_NODE				*Library;
	int						NumNodes;
	int						NumUsed;
	int						CurrentFont;
};

#endif