//============================================================
// Program:		CGFEntity
// Description:	Simple entity class
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_ENTITY_
#define _CGF_ENTITY_

#pragma warning(disable:4995)
#include <list.h>
#include <d3dx8.h>

#define ENTITY_MOTION_STEADY		1
#define ENTITY_MOTION_ACCELERATE	2

#define ENTITY_FORWARD		1
#define ENTITY_RIGHT		2
#define ENTITY_UP			4
#define ENTITY_YAW			8
#define ENTITY_PITCH		16
#define ENTITY_ROLL			32

#define ENTITY_ACTION_AUTOLEVEL	1

#define RENDER_TEXTURED		1
#define RENDER_LIT			2

class GameFrame;
class CGFEntity
{
public:
	CGFEntity();
	~CGFEntity();

	void Initialize(GameFrame *gfparent, list<int> &obj_lib_indices);
	void Reset(void);
	void Destroy(void);

	void SetActionFlags(DWORD flags);
	void SetRenderFlags(DWORD flags);
	void Move(DWORD type, DWORD direction, float speed);
	void Rotate(DWORD type, float speed);
	void Update(void);
	void Render(D3DXMATRIX *modifier = NULL);

	float FrictionDrag;
	float Radius;

	float X, Y, Z;
	float XVec, YVec, ZVec;

	float Yaw, Pitch, Roll;
	float YawVec, PitchVec, RollVec; 

	double Mass;

private:

	GameFrame	*GFParent;
	
	int			NumLibraryIndices;
	int			*LibraryIndices;

	DWORD		ActionFlags;
	DWORD		RenderFlags;

	D3DXVECTOR3 Up_Vector; 
	D3DXVECTOR3 Right_Vector; 
	D3DXVECTOR3 Look_Vector;
};

#endif
