//============================================================
// Program:		CGFCollisionHandler
// Description:	Collision Detection Class
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		who knows
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _GAME_FRAME_COLLISION_HANDLER_
#define _GAME_FRAME_COLLISION_HANDLER_

#pragma warning(disable:4995)
#include <d3dx8.h>

class GameFrame;
class CGFCamera;
class CGFEntity;
class CGFSolarSystem;
class CGFWeaponSystem;
class CGFCollisionHandler
{
public:

	CGFCollisionHandler();
	~CGFCollisionHandler();
	
	int Initialize(GameFrame *gfparent, CGFCamera *camera);
	void Destroy(void);
//	int AddEntity(CGFEntity *obj);		
	void SetSolarSystem(CGFSolarSystem *sys);
	void SetWeaponSystem(CGFWeaponSystem *sys);
	
	void HandleCollisions(void);

private:
	
	GameFrame* GFParent;
	CGFCamera *Camera;
	CGFSolarSystem *SolarSystem;
	CGFWeaponSystem *WeaponSystem;
};

#endif