//============================================================
// Program:		GameFrameCamera
// Description:	Class for simplifying camera control
// Author:		Benjamin Gottemoller
// Website:		http://www.particlefield.com
// Date:		4/20/01
// Legal:		Licensed under the gnu GPL (see gpl.txt for details)
//============================================================

#ifndef _CGF_CAMERA_
#define _CGF_CAMERA_

#pragma warning(disable:4995)
#include <d3dx8.h>
#include "GameFrameWeaponSystem.h"

#define CAMERA_MOTION_STEADY		1
#define CAMERA_MOTION_ACCELERATE	2

#define CAMERA_FORWARD		1
#define CAMERA_RIGHT		2
#define CAMERA_UP			4
#define CAMERA_YAW			8
#define CAMERA_PITCH		16
#define CAMERA_ROLL			32

#define CAMERA_ACTION_AUTOLEVEL		1

struct BINDKM	
{
	UINT Mouse;
	UCHAR Key;
};

struct BINDK	
{
	UCHAR Key;
};

struct CONTROL_BINDINGS
{
	float	MouseSensitivity;
	BINDK	YawPlus, YawMinus, PitchPlus, PitchMinus, RollPlus, RollMinus;
	BINDKM	Forward, Reverse, Left, Right, Up, Down; 
	BINDKM	Afterburner;
	BINDKM	FirePrimary, FireSecondary;
	int		WeaponWheel;
	BINDK	NextWeapon, PreviousWeapon;
	BINDKM	ZoomIn, ZoomOut;
	BINDKM	ToggleWarpDrive;
};

class CGFSolarSystem;
class GameFrame;
class CGFCamera
{
public:
	CGFCamera();
	~CGFCamera();

	void Initialize(GameFrame *gfparent);
	void LoadKeyBindings(char *file);
	void SaveKeyBindings(char *file);
	void EnableGravity(CGFSolarSystem *sys);
	void Reset(void);
	void Destroy(void);

	void SetActionFlags(DWORD flags);
	void Move(DWORD type, DWORD direction, float speed);
	void Rotate(DWORD type, float speed);
	void UpdateCamera(void);
	void DoCamera(D3DXMATRIX *modifier = NULL);

	CGFWeaponSystem		Arsenal;

	float X, Y, Z;
	float XVec, YVec, ZVec;
	D3DXVECTOR3 URLVec;

	float Yaw, Pitch, Roll;
	float YawVel, PitchVel, RollVel; 

	D3DXVECTOR3			Up_Vector; 
	D3DXVECTOR3			Right_Vector; 
	D3DXVECTOR3			Look_Vector;

	CONTROL_BINDINGS	Bindings;

	int					IsWarpDriveOn;
	float				WarpFactor;
	float				ZoomFactor;
	
private:

	void ProcessInput(void);

	GameFrame			*GFParent;
	CGFSolarSystem		*SolarSystem;
	DWORD				ActionFlags;
};

#endif

