// WinClockDlg.cpp : implementation file
//

#include <mmsystem.h>
#include "stdafx.h"
#include "WinClock.h"
#include "WinClockDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TIMER_ID	WM_USER + 1
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinClockDlg dialog

CWinClockDlg::CWinClockDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWinClockDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWinClockDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWinClockDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinClockDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWinClockDlg, CDialog)
	//{{AFX_MSG_MAP(CWinClockDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON1, OnSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinClockDlg message handlers

BOOL CWinClockDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString msg;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_OperationBox = (CComboBox *) GetDlgItem(IDC_COMBO1);
	m_ClockTimeBox1 = (CComboBox *) GetDlgItem(IDC_COMBO2);
	m_ClockTimeBox2 = (CDateTimeCtrl *) GetDlgItem(IDC_DATETIMEPICKER1);
	m_Clock1Check = (CButton *) GetDlgItem(IDC_RADIO1);
	m_Clock2Check = (CButton *) GetDlgItem(IDC_RADIO2);

	m_OperationBox->AddString("Standard");
	m_OperationBox->AddString("Whistle");
	m_OperationBox->AddString("Cuckoo");
	m_OperationBox->AddString("Fast Beep");
	m_OperationBox->AddString("Red Alert");
	m_OperationBox->AddString("Rooster");
	m_OperationBox->AddString("Crew Whistle");
	m_OperationBox->AddString("Annoying");
	m_OperationBox->SetCurSel(0);

	m_ClockTimeBox1->AddString("1 minute");
	for(int i=2; i<=720; i++)
	{
		msg.Format("%d minutes", i);
		m_ClockTimeBox1->AddString(msg);
	}
	m_ClockTimeBox1->SetCurSel(9);
	
	CTime mytime(21600);
	m_ClockTimeBox2->SetTime(&mytime);

	m_Clock1Check->SetCheck(1);

	m_ClockTimeBox2->EnableWindow(0);

	WeAreSet = 0;

	SetTimer(TIMER_ID, 1000, NULL);
	start_time = CTime::GetCurrentTime();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWinClockDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWinClockDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CWinClockDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWinClockDlg::OnRadio1() 
{
	m_ClockTimeBox1->EnableWindow(1);
	m_ClockTimeBox2->EnableWindow(0);		
}

void CWinClockDlg::OnRadio2() 
{
	m_ClockTimeBox1->EnableWindow(0);
	m_ClockTimeBox2->EnableWindow(1);		
}

afx_msg void CWinClockDlg::OnTimer(UINT ID)
{
	CString msg;
	CTimeSpan mytimer;
	long time_diff = 0;

	if(WeAreSet)
	{
		mytimer = finish_time - CTime::GetCurrentTime() + CTimeSpan(1, 0, 0, 0);

		msg.Format("WinClock   %d:%d:%d", mytimer.GetHours(), mytimer.GetMinutes(), mytimer.GetSeconds());
		SetWindowText(msg);
	
		time_diff = (mytimer.GetHours() * 60 * 60) +
					(mytimer.GetMinutes() * 60) +
					(mytimer.GetSeconds());
		if((time_diff < 1) || (time_diff > 86396))
		{
			WeAreSet = 0;
			RunOperation(OpState);
		}
	}
}

afx_msg void CWinClockDlg::OnDestroy()
{
	PlaySound(NULL, NULL, SND_PURGE);

	KillTimer(TIMER_ID);
}

void CWinClockDlg::OnSet() 
{
	PlaySound(NULL, NULL, SND_PURGE);
	if(m_Clock1Check->GetCheck())
	{
		finish_time = CTime::GetCurrentTime() + (m_ClockTimeBox1->GetCurSel() + 1) * 60;
	}
	
	if(m_Clock2Check->GetCheck())
	{
		CTime tmp_time;
		CTime curr_time = CTime::GetCurrentTime();

		m_ClockTimeBox2->GetTime(tmp_time);
		finish_time = CTime(curr_time.GetYear(), curr_time.GetMonth(), curr_time.GetDay(), 
							tmp_time.GetHour(), tmp_time.GetMinute(), tmp_time.GetSecond());
	}

	OpState = m_OperationBox->GetCurSel();

	WeAreSet = 1;
}

void CWinClockDlg::RunOperation(int num)
{
	switch(num)
	{
		case 0:
		{
			PlaySound("IDR_WAVE1", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);
		} break;

		case 1:
		{
			PlaySound("IDR_WAVE2", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);
		} break;

		case 2:
		{
			PlaySound("IDR_WAVE3", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;

		case 3:
		{
			PlaySound("IDR_WAVE4", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;

		case 4:
		{
			PlaySound("IDR_WAVE5", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;

		case 5:
		{
			PlaySound("IDR_WAVE6", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;

		case 6:
		{
			PlaySound("IDR_WAVE7", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;

		case 7:
		{
			PlaySound("IDR_WAVE8", GetModuleHandle("WinClock.exe"), SND_ASYNC | SND_RESOURCE | SND_LOOP);			
		} break;
	}
}
