

class ComControl
{
public:
	ComControl() { m_hCom = 0;}
	~ComControl();

	int OpenCom(char *ComPort); //Com1, Com2, Com3, Com4
	int CloseCom(void);

	int GetState(void);

	int Write(char *data, DWORD num_bytes);
	int Read(char *buffer, DWORD num_bytes);

	BOOL			bWriteRC;
	BOOL			bReadRC;
	DWORD			iBytesWritten;
	DWORD			iBytesRead;

private:

	BOOL			m_bPortReady;
	HANDLE			m_hCom;
	char			*m_sComPort;
	DCB				m_dcb;
	COMMTIMEOUTS	m_CommTimeouts;
};

/////////////////////////////////////////////////////////////////////////////////////////


class RelayControl
{
public:
	RelayControl() {Com = NULL;}

	int AttachComControl(ComControl *com);

	int IsDetected(void);

	int On(int i);		//activates relay i (1-8), (0 is all)
	int Off(int i);		//deactivates relay i (1-8), (0 is all)
	int Toggle(int i);	//toggles relay i (1-8), (0 is all)
	int Status(int i);	//returns relay i's status (1-8), (0 is all)

	int InputStatus(int i); //returns input status (1-4), (0 is all)
	
	char msg[130];

private:

	ComControl *Com;
};


/////////////////////////////////////////////////////////////////////////////////////////
ComControl::~ComControl()
{
	if(m_hCom)
	{
		CloseCom();
	}
}


int ComControl::OpenCom(char *ComPort)
{
	m_sComPort = ComPort;
	m_hCom = CreateFile(m_sComPort, 
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						0,
						NULL);
	if(m_hCom == INVALID_HANDLE_VALUE) return 0;

	m_bPortReady = SetupComm(m_hCom, 128, 128);
	if(!m_bPortReady) return 0;

	m_bPortReady = GetCommState(m_hCom, &m_dcb);
	if(!m_bPortReady) return 0;
	
	m_dcb.BaudRate = 9600;
	m_dcb.ByteSize = 8;
	m_dcb.Parity = NOPARITY;
	m_dcb.StopBits = ONESTOPBIT;
	m_dcb.fAbortOnError = TRUE;

	m_bPortReady = SetCommState(m_hCom, &m_dcb);
	if(!m_bPortReady) return 0;

	m_bPortReady = GetCommTimeouts(m_hCom, &m_CommTimeouts);
	if(!m_bPortReady) return 0;

	m_CommTimeouts.ReadIntervalTimeout = 100;
	m_CommTimeouts.ReadTotalTimeoutConstant = 100;
	m_CommTimeouts.ReadTotalTimeoutMultiplier = 10;
	m_CommTimeouts.WriteTotalTimeoutConstant = 100;
	m_CommTimeouts.WriteTotalTimeoutMultiplier = 10;

	m_bPortReady = SetCommTimeouts(m_hCom, &m_CommTimeouts);
	if(!m_bPortReady) return 0;

	return 1;
}


int ComControl::CloseCom(void)
{
	return CloseHandle(m_hCom);
	m_hCom = 0;
}

int ComControl::GetState(void)
{
	if(m_hCom == 0) 
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

int ComControl::Write(char *data, DWORD num_bytes)
{
	bWriteRC = WriteFile(m_hCom, data, num_bytes, &iBytesWritten, NULL);
	if(bWriteRC == 0) return 0;
	return 1;
}


int ComControl::Read(char *buffer, DWORD num_bytes)
{
	bReadRC = ReadFile(m_hCom, buffer, num_bytes, &iBytesRead, NULL);
	if(bReadRC == 0) return 0;
	return 1;
}

/////////////////////////////////////////////////////////////////////////////////////////

int RelayControl::AttachComControl(ComControl *com)
{
	if(com == NULL) return 0;
	Com = com;
	strset(msg, '\0');
	return 1;
}

int RelayControl::IsDetected(void)
{
	if(Status(1) == -1) return 0;
	return 1;
}

int RelayControl::On(int i)
{
	if(Com == NULL) return 0;
	if((i < 0) || (i > 8)) return 0;
	
	char buffer[10];

	sprintf(buffer, "N%d\r", i);
	if(!Com->Write(buffer, 3)) return 0;
	
	strset(msg, '\0');
	Com->Read(msg, 128);

	return 1;
}


int RelayControl::Off(int i)
{
	if(Com == NULL) return 0;
	if((i < 0) || (i > 8)) return 0;

	char buffer[10];

	sprintf(buffer, "F%d\r", i);
	if(!Com->Write(buffer, 3)) return 0;
	
	strset(msg, '\0');
	Com->Read(msg, 128);

	return 1;
}


int RelayControl::Toggle(int i)
{
	if(Com == NULL) return 0;
	if((i < 0) || (i > 8)) return 0;

	char buffer[10];

	sprintf(buffer, "T%d\r", i);
	if(!Com->Write(buffer, 3)) return 0;
	
	strset(msg, '\0');
	Com->Read(msg, 128);

	return 1;
}


int RelayControl::Status(int i)
{
	if(Com == NULL) return -1;
	if((i < 0) || (i > 8)) return -1;

	int j = 0, start = 0;
	char buffer[10];
		
	sprintf(buffer, "S%d\r", i);
	if(!Com->Write(buffer, 3)) return -1;

	strset(msg, '\0');
	if(!Com->Read(msg, 128)) return -1;

	for(j=0; j<8; j++)
	{
		if(msg[j] == 'S') 
		{
			start = j + 2;
		}
	}

	for(j=start; j<8; j++)
	{
		if(msg[j] == '0') return 0;
	}
	
	return 1;
}


int RelayControl::InputStatus(int i)
{
	if(Com == NULL) return 0;
	if((i < 0) || (i > 4)) return 0;

	int j, start = 0;
	char buffer[10];
		
	sprintf(buffer, "I%d\r", i);
	if(!Com->Write(buffer, 3)) return -1;

	strset(msg, '\0');
	if(!Com->Read(msg, 128)) return -1;

	for(j=0; j<8; j++)
	{
		if(msg[j] == 'I') 
		{
			start = j + 2;
		}
	}

	for(j=start; j<8; j++)
	{
		if(msg[j] == '0') return 0;
	}
	
	return 1;
}

/////////////////////////////////////////////////////////////////////////////////////////
RelayControl *tmp_relay_ptr = NULL;
int TimedOn(RelayControl *relay, HWND hwnd, int i, DWORD time);
VOID CALLBACK RelayTimer(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

int TimedOn(RelayControl *relay, HWND hwnd, int i, DWORD time)
{
	if((i < 0) || (i > 8)) return 0;
	if(relay == NULL) return 0;

	tmp_relay_ptr = relay;
	tmp_relay_ptr->On(i);
	
	if(!SetTimer(hwnd, i + 1, time, RelayTimer)) return 0;
	return 1;
}


VOID CALLBACK RelayTimer(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	int index = idEvent - 1;
	tmp_relay_ptr->Off(index);
	KillTimer(hwnd, idEvent);
}

