#include "DirectX.h"
#include "Engines.h"

/////////////////////////////////////////////////////////////////////
#define SCREEN_WIDTH	1024
#define SCREEN_HEIGHT	768
#define SCREEN_BPP		32
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
#define   WINDOW_CLASS_NAME "WINXCLASS"  
#define   WIN_WIDTH      10  
#define   WIN_HEIGHT     10
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
#define KEY_DOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define KEY_UP(vk_code)   ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Init(void);
int Game_Menu(void); 
int Game_Main(void);
int Game_Shutdown(void);
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
BOOL GameRunning=1;
char buffer[80];   

RayCaster Player;

float map[32*32] = {   
2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,
8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,9,8,9,8,9,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,9,8,9,8,9,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,6,0,6,0,0,5,4,5,4,5,4,5,4,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,9,4,0,4,0,0,4,0,0,0,0,0,9,5,0,0,0,0,0,0,0,0,8,
8,0,0,4,6,4,6,4,6,4,6,0,6,0,0,5,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,2,
2,0,0,6,0,0,0,0,0,0,0,0,4,0,0,4,0,5,4,5,4,0,5,4,5,4,5,0,0,0,0,8,
8,0,0,4,0,4,6,4,6,4,6,4,6,0,0,7,0,7,0,0,5,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,6,0,6,0,0,0,0,0,0,0,0,0,3,0,3,0,0,4,0,0,0,0,0,4,0,0,0,0,8,
8,7,3,4,0,4,3,7,3,7,3,7,3,7,3,7,0,7,3,7,3,7,0,0,0,0,5,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,4,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,3,7,5,0,5,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,3,7,5,5,5,0,0,0,0,2,
2,7,3,7,3,7,3,7,3,0,0,3,7,3,7,3,7,3,7,3,7,3,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,7,0,0,7,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,0,0,9,0,0,9,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,8,9,0,8,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,9,8,9,8,9,8,0,9,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,8,0,0,0,0,0,0,8,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,9,0,8,9,8,9,8,9,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,8,0,9,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,9,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,8,9,8,9,8,9,8,9,8,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,0,0,0,9,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,0,0,0,0,0,0,0,0,0,0,0,8,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,
8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2,8,2};

/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	PAINTSTRUCT	ps;		
	HDC			hdc;

	switch(msg)
	{	
		case WM_CREATE: 
        {
			return(0);
		} break;

		case WM_PAINT:
        {
			hdc = BeginPaint(hwnd,&ps);
            EndPaint(hwnd,&ps);
			return(0);
        } break;

		case WM_DESTROY: 
		{
			PostQuitMessage(0);
			return(0);
		} break;

		default:break;
    }

	return (DefWindowProc(hwnd, msg, wparam, lparam));
} 
/////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
int WINAPI WinMain(	HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{

	WNDCLASS winclass;	// this will hold the class we create
	HWND	 hwnd;		// generic window handle
	MSG		 msg;		// generic message

	winclass.style			= CS_DBLCLKS | CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	winclass.lpfnWndProc	= WindowProc;
	winclass.cbClsExtra		= 0;
	winclass.cbWndExtra		= 0;
	winclass.hInstance		= hinstance;
	winclass.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
	winclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	winclass.hbrBackground	= (HBRUSH) GetStockObject(BLACK_BRUSH);
	winclass.lpszMenuName	= NULL; 
	winclass.lpszClassName	= WINDOW_CLASS_NAME;

	if (!RegisterClass(&winclass))
	return(0);

	hwnd = CreateWindow( WINDOW_CLASS_NAME, 
                         "DeepSky",
						 WS_POPUP | WS_VISIBLE,
					 	 0,0,	   
						 WIN_WIDTH,
						 WIN_HEIGHT,
						 NULL,	   
						 NULL,	   
						 hinstance,
						 NULL
					   );
	
	if(!hwnd) return(0);

	main_window_handle = hwnd;	
	main_instance      = hinstance;

	DD_Init(SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP);
	Game_Init();

	while(GameRunning)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
				break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
    
		Game_Main();
	}

	Game_Shutdown();
	DD_Shutdown();

	return(msg.wParam);
}
/////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
int Game_Init(void)
{
	srand(GetTickCount());
	ShowCursor(FALSE);

	Player.SetViewport(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    Player.SetWorld(32, 32, map);
    Player.SetCamera(3, 3, 45, 60);
	
	return(1);
}
/////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
int Game_Shutdown(void)
{
	ShowCursor(TRUE);
	return(1);
} // end Game_Shutdown
/////////////////////////////////////////////////////////////////////


DWORD t0=0, t1=1, sleep_time=0;
/////////////////////////////////////////////////////////////////////
int Game_Main(void)
{
	t0 = GetTickCount();
	
	DD_Fill_Surface(lpddsback, 0);
	
	if (KEY_DOWN(VK_ESCAPE))
	{
		PostMessage(main_window_handle, WM_DESTROY,0,0);
	}
	
    if(KEY_DOWN(VK_LEFT))
    {
		Player.Angle -= .1f*t1;
    }

    if(KEY_DOWN(VK_RIGHT))
    {
		Player.Angle += .1f*t1;
    }
      
    if(KEY_DOWN(VK_UP))
    {
		Player.Travel(.08f*t1);
    }
 
    if(KEY_DOWN(VK_DOWN))
    {
		Player.Travel(-.08f*t1);
    }

	if(KEY_DOWN('A')) sleep_time++;
	if(KEY_DOWN('Z')) sleep_time--;

	Player.CastRays();
	DD_Wait_Retrace();
	DD_Flip();
	Sleep(sleep_time);

	t1 = GetTickCount() - t0;
	return(1);
} 
/////////////////////////////////////////////////////////////////////


