
/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/

#include "vector.h"

VECTOR3 operator+(const VECTOR3 &vector1, const VECTOR3 &vector2)
{
	return VECTOR3(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z);
}

VECTOR3 operator-(const VECTOR3 &vector1, const VECTOR3 &vector2)
{
	return VECTOR3(vector1.x - vector2.x, vector1.y - vector2.y, vector1.z - vector2.z);
}

VECTOR3::VECTOR3(float x, float y, float z)
{
	VECTOR3::x = x;
	VECTOR3::y = y;
	VECTOR3::z = z;
}

const VECTOR3& VECTOR3::operator=(const VECTOR3 &vector)
{
	x = vector.x;
	y = vector.y;
	z = vector.z;
	return *this;
}

const VECTOR3& VECTOR3::operator+=(const VECTOR3 &vector)
{
	x += vector.x;
	y += vector.y;
	z += vector.z;
	return *this;
}

const VECTOR3& VECTOR3::operator-=(const VECTOR3 &vector)
{
	x -= vector.x;
	y -= vector.y;
	z -= vector.z;
	return *this;
}

const VECTOR3& VECTOR3::operator*=(const float scalar)
{
	x *= scalar;
	y *= scalar;
	z *= scalar;
	return *this;
}

const VECTOR3& VECTOR3::operator/=(const float scalar)
{
	x /= scalar;
	y /= scalar;
	z /= scalar;
	return *this;
}

float VECTOR3::Length()
{
	return (float)sqrt((x * x) + (y * y) + (z * z)); 
}

void VECTOR3::Normalize()
{
	float length = Length();
	x /= length;
	y /= length;
	z /= length;
}

VECTOR3 operator*(const VECTOR3 &vector1, const float scalar)
{
	return VECTOR3(vector1.x * scalar, vector1.y * scalar, vector1.z * scalar);
}

VECTOR3 operator/(const VECTOR3 &vector1, const float scalar)
{
	return VECTOR3(vector1.x / scalar, vector1.y / scalar, vector1.z / scalar);
}

VECTOR3 Vec3CrossProduct(const VECTOR3 &vector1, const VECTOR3 &vector2)
{
	return VECTOR3((vector1.y * vector2.z) - (vector1.z * vector2.y), 
				  -(vector1.x * vector2.z) + (vector1.z * vector2.x),
				   (vector1.x * vector2.y) - (vector1.y * vector2.x));
}

float Vec3DotProduct(const VECTOR3 &vector1, const VECTOR3 &vector2)
{
	return ((vector1.x * vector2.x) + 
			(vector1.y * vector2.y) + 
			(vector1.z * vector2.z));
}
