
/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/

#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <stdio.h>
#include <math.h>
#include <memory.h>
#include "vector.h"

#ifndef DWORD
#define DWORD		unsigned long
#endif

#ifndef UCHAR
#define UCHAR		unsigned char
#endif

const float PI = 3.14159265f;

template<class T>
void SWAP(T &a, T &b)
{
	T c;
	c = a;
	a = b;
	b = c;
}

class MATRIX
{
public:

	MATRIX();
	MATRIX(MATRIX &mat);
	void LoadIdentity(void);
	void Transpose(void);
	void LoadRotationX(float angle);
	void LoadRotationY(float angle);
	void LoadRotationZ(float angle);
	void LoadScaling(float x, float y, float z);
	void LoadTranslation(float x, float y, float z);
	
	void LoadHermite(VECTOR3 &P1, VECTOR3 &P4, VECTOR3 &R1, VECTOR3 &R4);
	VECTOR3 ComputeCurvePoint(float u);

	const MATRIX& operator=(const MATRIX &mat);
	const MATRIX& operator*=(const MATRIX &mat);
	inline float& operator[](int index) { return matrix[index]; }

	float matrix[4 * 4];
};
MATRIX operator*(const MATRIX &mat1, const MATRIX &mat2);
VECTOR3 operator*(const MATRIX &mat, const VECTOR3 &vector);
VECTOR3 operator*(const VECTOR3 &vector, const MATRIX &mat);
MATRIX CreateAxisAngleRotationMat(float angle, float x, float y, float z);

#endif
