
/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/


#include "matrix.h"

MATRIX::MATRIX()
{
	LoadIdentity();
}

MATRIX::MATRIX(MATRIX &mat)
{
	*this = mat;
}
	
void MATRIX::LoadIdentity(void)
{
	matrix[0 ] = 1;  matrix[1 ] = 0;  matrix[2 ] = 0;  matrix[3] = 0; 
	matrix[4 ] = 0;  matrix[5 ] = 1;  matrix[6 ] = 0;  matrix[7] = 0; 
	matrix[8 ] = 0;  matrix[9 ] = 0;  matrix[10] = 1;  matrix[11] = 0; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::Transpose(void)
{
	SWAP(matrix[4], matrix[1]);
	SWAP(matrix[8], matrix[2]);
	SWAP(matrix[9], matrix[6]);
	SWAP(matrix[12], matrix[3]);
	SWAP(matrix[13], matrix[7]);
	SWAP(matrix[14], matrix[11]);
}

void MATRIX::LoadRotationX(float angle)
{
	float c = (float)cos(angle);
	float s = (float)sin(angle);

	matrix[0 ] = 1;  matrix[1 ] = 0;  matrix[2 ] = 0;  matrix[3] = 0; 
	matrix[4 ] = 0;  matrix[5 ] = c;  matrix[6 ] = -s; matrix[7] = 0; 
	matrix[8 ] = 0;  matrix[9 ] = s;  matrix[10] = c;  matrix[11] = 0; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::LoadRotationY(float angle)
{
	float c = (float)cos(angle);
	float s = (float)sin(angle);

	matrix[0 ] = c;  matrix[1 ] = 0;  matrix[2 ] = s;  matrix[3] = 0; 
	matrix[4 ] = 0;  matrix[5 ] = 1;  matrix[6 ] = 0;  matrix[7] = 0; 
	matrix[8 ] = -s; matrix[9 ] = 0;  matrix[10] = c;  matrix[11] = 0; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::LoadRotationZ(float angle)
{
	float c = (float)cos(angle);
	float s = (float)sin(angle);

	matrix[0 ] = c;  matrix[1 ] = -s; matrix[2 ] = 0;  matrix[3] = 0; 
	matrix[4 ] = s;  matrix[5 ] = c;  matrix[6 ] = 0;  matrix[7] = 0; 
	matrix[8 ] = 0;  matrix[9 ] = 0;  matrix[10] = 1;  matrix[11] = 0; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::LoadScaling(float x, float y, float z)
{
	matrix[0 ] = x;  matrix[1 ] = 0;  matrix[2 ] = 0;  matrix[3] = 0; 
	matrix[4 ] = 0;  matrix[5 ] = y;  matrix[6 ] = 0;  matrix[7] = 0; 
	matrix[8 ] = 0;  matrix[9 ] = 0;  matrix[10] = z;  matrix[11] = 0; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::LoadTranslation(float x, float y, float z)
{
	matrix[0 ] = 1;  matrix[1 ] = 0;  matrix[2 ] = 0;  matrix[3] = x; 
	matrix[4 ] = 0;  matrix[5 ] = 1;  matrix[6 ] = 0;  matrix[7] = y; 
	matrix[8 ] = 0;  matrix[9 ] = 0;  matrix[10] = 1;  matrix[11] = z; 
	matrix[12] = 0;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 1; 
}

void MATRIX::LoadHermite(VECTOR3 &P1, VECTOR3 &P4, VECTOR3 &R1, VECTOR3 &R4)
{
	MATRIX g;

	matrix[0 ] = 2;  matrix[1 ] = -2; matrix[2 ] = 1;  matrix[3] = 1; 
	matrix[4 ] = -3; matrix[5 ] = 3;  matrix[6 ] = -2; matrix[7] = -1; 
	matrix[8 ] = 0;  matrix[9 ] = 0;  matrix[10] = 1;  matrix[11] = 0; 
	matrix[12] = 1;  matrix[13] = 0;  matrix[14] = 0;  matrix[15] = 0;
	
	g[0 ] = P1.x;  g[1 ] = P1.y;  g[2 ] = P1.z;  g[3 ] = 0;  
	g[4 ] = P4.x;  g[5 ] = P4.y;  g[6 ] = P4.z;  g[7 ] = 0;  
	g[8 ] = R1.x;  g[9 ] = R1.y;  g[10] = R1.z;  g[11] = 0;  
	g[12] = R4.x;  g[13] = R4.y;  g[14] = R4.z;  g[15] = 0;  

	*this = (*this) * g;
}

VECTOR3 MATRIX::ComputeCurvePoint(float u)
{
	VECTOR3 U(u*u*u, u*u, u);
	return U * (*this);
}

const MATRIX& MATRIX::operator=(const MATRIX &mat)
{
	memcpy(matrix, mat.matrix, sizeof(float) * 16);
	return *this;
}

const MATRIX& MATRIX::operator*=(const MATRIX &mat)
{
	MATRIX tmp = *this;
	*this = tmp * mat;
	return *this;
}

MATRIX operator*(const MATRIX &mat1, const MATRIX &mat2)
{
	MATRIX tmp;

	tmp.matrix[0] =  (mat1.matrix[0] * mat2.matrix[0]) + 
					 (mat1.matrix[1] * mat2.matrix[4]) +
					 (mat1.matrix[2] * mat2.matrix[8]) +
					 (mat1.matrix[3] * mat2.matrix[12]);

	tmp.matrix[1] =  (mat1.matrix[0] * mat2.matrix[1]) + 
					 (mat1.matrix[1] * mat2.matrix[5]) +
					 (mat1.matrix[2] * mat2.matrix[9]) +
					 (mat1.matrix[3] * mat2.matrix[13]);

	tmp.matrix[2] =  (mat1.matrix[0] * mat2.matrix[2]) + 
					 (mat1.matrix[1] * mat2.matrix[6]) +
					 (mat1.matrix[2] * mat2.matrix[10]) +
					 (mat1.matrix[3] * mat2.matrix[14]);

	tmp.matrix[3] =  (mat1.matrix[0] * mat2.matrix[3]) + 
					 (mat1.matrix[1] * mat2.matrix[7]) +
					 (mat1.matrix[2] * mat2.matrix[11]) +
					 (mat1.matrix[3] * mat2.matrix[15]);

	tmp.matrix[4] =  (mat1.matrix[4] * mat2.matrix[0]) + 
					 (mat1.matrix[5] * mat2.matrix[4]) +
					 (mat1.matrix[6] * mat2.matrix[8]) +
					 (mat1.matrix[7] * mat2.matrix[12]);

	tmp.matrix[5] =  (mat1.matrix[4] * mat2.matrix[1]) + 
					 (mat1.matrix[5] * mat2.matrix[5]) +
					 (mat1.matrix[6] * mat2.matrix[9]) +
					 (mat1.matrix[7] * mat2.matrix[13]);

	tmp.matrix[6] =  (mat1.matrix[4] * mat2.matrix[2]) + 
					 (mat1.matrix[5] * mat2.matrix[6]) +
					 (mat1.matrix[6] * mat2.matrix[10]) +
					 (mat1.matrix[7] * mat2.matrix[14]);

	tmp.matrix[7] =  (mat1.matrix[4] * mat2.matrix[3]) + 
					 (mat1.matrix[5] * mat2.matrix[7]) +
					 (mat1.matrix[6] * mat2.matrix[11]) +
					 (mat1.matrix[7] * mat2.matrix[15]);

	tmp.matrix[8] =  (mat1.matrix[8] * mat2.matrix[0]) + 
					 (mat1.matrix[9] * mat2.matrix[4]) +
					 (mat1.matrix[10] * mat2.matrix[8]) +
					 (mat1.matrix[11] * mat2.matrix[12]);

	tmp.matrix[9] =  (mat1.matrix[8] * mat2.matrix[1]) + 
					 (mat1.matrix[9] * mat2.matrix[5]) +
					 (mat1.matrix[10] * mat2.matrix[9]) +
					 (mat1.matrix[11] * mat2.matrix[13]);

	tmp.matrix[10] = (mat1.matrix[8] * mat2.matrix[2]) + 
					 (mat1.matrix[9] * mat2.matrix[6]) +
					 (mat1.matrix[10] * mat2.matrix[10]) +
					 (mat1.matrix[11] * mat2.matrix[14]);

	tmp.matrix[11] = (mat1.matrix[8] * mat2.matrix[3]) + 
					 (mat1.matrix[9] * mat2.matrix[7]) +
					 (mat1.matrix[10] * mat2.matrix[11]) +
					 (mat1.matrix[11] * mat2.matrix[15]);

	tmp.matrix[12] = (mat1.matrix[12] * mat2.matrix[0]) + 
					 (mat1.matrix[13] * mat2.matrix[4]) +
					 (mat1.matrix[14] * mat2.matrix[8]) +
					 (mat1.matrix[15] * mat2.matrix[12]);

	tmp.matrix[13] = (mat1.matrix[12] * mat2.matrix[1]) + 
					 (mat1.matrix[13] * mat2.matrix[5]) +
					 (mat1.matrix[14] * mat2.matrix[9]) +
					 (mat1.matrix[15] * mat2.matrix[13]);

	tmp.matrix[14] = (mat1.matrix[12] * mat2.matrix[2]) + 
					 (mat1.matrix[13] * mat2.matrix[6]) +
					 (mat1.matrix[14] * mat2.matrix[10]) +
					 (mat1.matrix[15] * mat2.matrix[14]);

	tmp.matrix[15] = (mat1.matrix[12] * mat2.matrix[3]) + 
					 (mat1.matrix[13] * mat2.matrix[7]) +
					 (mat1.matrix[14] * mat2.matrix[11]) +
					 (mat1.matrix[15] * mat2.matrix[15]);
	return tmp;
}

VECTOR3 operator*(const MATRIX &mat, const VECTOR3 &vector)
{
	VECTOR3 tmp;
	float w;

	tmp.x = (mat.matrix[0] * vector.x) +
			(mat.matrix[1] * vector.y) +
			(mat.matrix[2] * vector.z) +
			(mat.matrix[3] * 1);

	tmp.y = (mat.matrix[4] * vector.x) +
			(mat.matrix[5] * vector.y) +
			(mat.matrix[6] * vector.z) +
			(mat.matrix[7] * 1);

	tmp.z = (mat.matrix[8] * vector.x) +
			(mat.matrix[9] * vector.y) +
			(mat.matrix[10] * vector.z) +
			(mat.matrix[11] * 1);
	
	w     = (mat.matrix[12] * vector.x) +
			(mat.matrix[13] * vector.y) +
			(mat.matrix[14] * vector.z) +
			(mat.matrix[15] * 1);

	if(w != 0)
	{
		tmp /= w;
	}
	return tmp;
}

VECTOR3 operator*(const VECTOR3 &vector, const MATRIX &mat)
{
	VECTOR3 tmp;
	float w;

	tmp.x = (vector.x * mat.matrix[0]) + 
			(vector.y * mat.matrix[4]) +
			(vector.z * mat.matrix[8]) +
			(1        * mat.matrix[12]);

	tmp.y = (vector.x * mat.matrix[1]) + 
			(vector.y * mat.matrix[5]) +
			(vector.z * mat.matrix[9]) +
			(1        * mat.matrix[13]);

	tmp.z = (vector.x * mat.matrix[2]) + 
			(vector.y * mat.matrix[6]) +
			(vector.z * mat.matrix[10]) +
			(1        * mat.matrix[14]);

	w	  = (vector.x * mat.matrix[3]) + 
			(vector.y * mat.matrix[7]) +
			(vector.z * mat.matrix[11]) +
			(1        * mat.matrix[15]);

	if(w != 0)
	{
		tmp /= w;
	}
	return tmp;
}

MATRIX CreateAxisAngleRotationMat(float angle, float x, float y, float z)
{
	MATRIX mat;
	float length = (float)sqrt(x*x + y*y + z*z);
	float c = (float)cos(angle);
	float s = (float)sin(angle);
	float t = 1 - c;

	x /= length;
	y /= length;
	z /= length;

	mat.matrix[0] = t * x * x + c;
	mat.matrix[1] = t * x * y - s * z;
	mat.matrix[2] = t * x * z + s * y;
	mat.matrix[3] = 0;

	mat.matrix[4] = t * x * y + s * z;
	mat.matrix[5] = t * y * y + c;
	mat.matrix[6] = t * y * z - s * x;
	mat.matrix[7] = 0;

	mat.matrix[8] = t * x * z - s * y;
	mat.matrix[9] = t * y * z + s * x;
	mat.matrix[10] = t * z * z + c;
	mat.matrix[11] = 0;
	
	return mat;
}
