/************************************************************************

  CS 318: MP3 -- The World in Motion
    see http://www-courses.cs.uiuc.edu/~cs318/mp/mp3.html for details

  NAME   : Benjamin Gottemoller
  NET ID : gottemol

 ************************************************************************/

#ifndef _GLENGINE_H_
#define _GLENGINE_H_


#include <stdio.h>
#include <string.h>
#include <gfx/gui.h>
#include <gfx/gl.h>
#include <gfx/gfx.h>

#include <FL/fl_color_chooser.h>
#include <FL/fl_file_chooser.h>
#include <FL/filename.h>
#include <FL/fl_ask.h>
#include <FL/fl.h>
#include <FL/fl_window.h>
#include <FL/fl_input.h>
#include <FL/fl_button.h>
#include <FL/fl_return_button.h>

#include "matrix.h"
#include "vector.h"

#ifndef DWORD
#define DWORD		unsigned long
#endif

#ifndef UCHAR
#define UCHAR		unsigned char
#endif

#define ABS(a)			((a < 0) ? (-(a)) : (a))
#define KEY_DOWN(key)   ((GetAsyncKeyState(key) & 0x8000) ? 1 : 0)


#define CAMERA_FORWARD		1
#define CAMERA_RIGHT		2
#define CAMERA_UP			4
#define CAMERA_YAW			8
#define CAMERA_PITCH		16
#define CAMERA_ROLL			32

class COLOR
{
public:

	COLOR() { r = g = b = a = 0; }
	COLOR(float r, float g, float b, float a);
	COLOR(int r, int g, int b, int a);

	const COLOR& COLOR::operator=(COLOR &color);
	COLOR operator*(float value);
	COLOR operator/(float value);

	float r, g, b, a;
};

struct VERTEX
{
	VECTOR3 Position;  
	VECTOR3 Normal;
};

struct FACE
{
	int a, b, c;
};

class GL_Material
{
public:
    
    GL_Material();
    void SetMaterial();

public:

	COLOR Diffuse;			// Fraction of incoming light reflected diffusely 
	COLOR Ambient;			// Fraction of ambient light reflected
	COLOR Emissive;			// Light emitted by this material 
    COLOR Specular;			// Fraction of incoming light reflected specularly

	float Power;			// Exponent for Phong illumination model
};

class GL_FrameRateTracker
{
public:

	GL_FrameRateTracker();

	void Initialize(void);
	void Update(void);

	float			TimeDiff;
	float			FPS;	

private:

	__int64			ProgramStartTime;
	__int64			StartTime;
	__int64			FrameCount;
	__int64			LastTime;
	__int64			CounterFrequency;
};

class GL_KeyFrameSystem
{
	struct KEY_FRAME
	{
		float TimeStamp;
		VECTOR3 Position;
		VECTOR3 Rotation;

		float du;
		MATRIX HP, HR;
	};

public:

	GL_KeyFrameSystem();
	~GL_KeyFrameSystem();

	int IsReady() { return (KeyFrames != NULL); }

	void LoadKeys(char *file);
	void Destroy(void);
	void RenderKeyPath(void);

	void Reset(void);
	void Update(float time_diff);

	VECTOR3 Position;
	VECTOR3 Rotation;

private:

	int					NumKeyFrames;
	int					NumHermiteCurves;
	KEY_FRAME			*KeyFrames;

	float				CurrentTime;
	int					CurrentHermiteCurve;
};

class GL_Object
{
public:
        
	GL_Object(GL_Material *material, GL_FrameRateTracker *timer);
    
	void			Update(void);
    virtual void	Render();

    virtual void	ComputeBoundingBox(VECTOR3 &min, VECTOR3 &max) = 0;
    void			RenderBoundingBox();
	
public:

	int IsAnimationPlaying;
	GL_KeyFrameSystem KFS;

	VECTOR3		Position;
	VECTOR3		Scale;
	float		Yaw, Pitch, Roll;
	
	MATRIX		Transform;

	VECTOR3 Look_Vector;
	VECTOR3 Up_Vector;
	VECTOR3 Right_Vector;

	GL_Material Material;

private:

	GL_FrameRateTracker *Timer;
};

class GL_HierarchicalModel
{
public:
	
	GL_HierarchicalModel();

	void InitModel(int num_children, int quadric_type);
	void LoadKeyFrames(char *directory_path, GL_HierarchicalModel *parent = NULL);
	void SetupProperties(GL_Material *material, GL_FrameRateTracker *timer);
	void Destroy();
	void UpdateAndRenderHierarchy() { UpdateAndRenderHierarchy(NULL); }
	
	void RenderKeyPath();
	void ResetAnimation();

	VECTOR3	Position, Center, Joint;
	float Yaw, Pitch, Roll;
	
	GL_KeyFrameSystem KFS;
	static int IsAnimationPlaying;


	void UpdateAndRenderHierarchy(GL_HierarchicalModel *parent);

	GL_Material Material;
	static GL_FrameRateTracker *Timer;
	int QuadricType;
	GLUquadric *Quadric;
	int NumChildren;
	GL_HierarchicalModel *Children;
};

class GL_Camera
{
public:

	GL_Camera(GL_FrameRateTracker *timer);

	void Move(DWORD type, float speed);
	void Rotate(DWORD type, float angle);
	void SetupCamera(float width, float height);
	void Look(void);

	int IsAnimationPlaying;
	GL_KeyFrameSystem KFS;

	float Yaw, Pitch, Roll;

	VECTOR3 Position;

	VECTOR3 Look_Vector;
	VECTOR3 Up_Vector;
	VECTOR3 Right_Vector;

private:

	GL_FrameRateTracker *Timer;
};

class Sphere : public GL_Object
{
public:

    Sphere(const VECTOR3 &center, float radius, GL_Material *material, GL_FrameRateTracker *timer);

    virtual void Render();
    virtual void ComputeBoundingBox(VECTOR3 &min, VECTOR3 &max);


public:

	VECTOR3		Center;
    float		Radius;

private:

    static GLUquadric *Quadric;

};


class Cylinder : public GL_Object
{
public:

	struct CYLINDER_COMPONENT
	{
		float v;
		float radius;
	};

    Cylinder(char * file, int segments, int slices, const VECTOR3 &center, GL_Material *material, GL_FrameRateTracker *timer);
	~Cylinder();

    virtual void Render();
    virtual void ComputeBoundingBox(VECTOR3 &min, VECTOR3 &max);


public:

	VECTOR3		Center;
	float		Height;
	float		MaxRadius;
    
private:

	int NumFaces;
	FACE *Faces;

	int NumVertices;
    VERTEX *Vertices;

};

class GL_Level
{
public:

	GL_Level();

    void Render();   

	GL_Material Material;
};

class GL_ParticleSystem
{
	struct PARTICLE
	{
		int 			IsActive;
		int				TextureIndex;
		VECTOR3			Pos;
		VECTOR3			LastPos;
		VECTOR3			Velocity;
		float			Scale;
		COLOR			Color;
		int				MaxLife;	
		int				Age;		
		float			Mass;
	};

	struct SPRING_PAIR
	{
		int				IsActive;
		int				Index1;
		int				Index2;
		float			RestLength;
		float			K;
	};

public:

	GL_ParticleSystem();
	~GL_ParticleSystem();

	int Initialize(int num_particles);
	void SetCamera(GL_Camera *camera)	{ Camera = camera; }
	void Destroy(void);

	void ConnectPair(int index1, int index2, float rest_length, float k);

	int	AddParticle(int tex_index, float x, float y, float z, 
					float xv, float yv, float zv, float scale, 
					COLOR color, int max_life, float mass);

	void KillParticles(void);

	void Update(void);					
	void Render(void);					

	inline int GetNumActive(void)		{ return NumParticlesActive; }
	inline int GetNumParticles(void)	{ return NumParticles; }

	int IsParticleEngineActive;

private:
	
	GL_Camera			*Camera;

	int					NumParticles;
	int					NumParticlesActive;
	PARTICLE			*Particles;

	int					NumSpringPairs;
	int					NumSpringPairsActive;
	SPRING_PAIR			*SpringPairs;
};


#endif