/////////////////////////////////////////////////////////////////////
#include "DXEngine.h"
#include "DXLibrary.h"
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
const int SCREEN_WIDTH = 1024;
const int SCREEN_HEIGHT = 768;
const int BPP = 16;

const int MAX_X = SCREEN_WIDTH;
const int MAX_Y = SCREEN_HEIGHT;
const int MID_X = SCREEN_WIDTH / 2;
const int MID_Y = SCREEN_HEIGHT / 2;
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Init();
int Game_Menu();
int Game_Main();
int Game_Shutdown();
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
BOOL ShutdownApp = 0; 
char buffer[80];  
              
DXEngine dxengine;
CFrameRate fps;

Sparky2D sparky;

void DrawCartGraph(DWORD color, int xs, int ys);
void CartPixel(float x, float y, DWORD color);
void CartLine(float x1, float y1, float x2, float y2, DWORD color);

void DoSinGraph(float period);
void DoDistortedGraph(float period);

void DoSphere(DWORD color);
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{	
	dxengine.WinInit(hinstance, "DDBackdrop", "Particle");
	dxengine.DDInit(SCREEN_WIDTH, SCREEN_HEIGHT, BPP);

	RECT ClipList = {0,0,SCREEN_WIDTH,SCREEN_HEIGHT};
	dxengine.DDAttachClipper(&ClipList, 1);

	dxengine.DDAttachPalette(NULL);
	
	MSG	msg;		
	Game_Init();

	while(!ShutdownApp)
	{
		if(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0)) return msg.wParam;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			if(dxengine.IsActive()) Game_Main();
		}
	}

	Game_Shutdown();

	return(msg.wParam);
}
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Init()
{
	srand(GetTickCount());
	sparky.SetGravity(.01f);
	sparky.SetWind(.01f);
	ShowCursor(TRUE);
	return(1);
}
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Menu(void)
{
	return(1);
}
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////

int Game_Main()
{
	static float x = MID_X, y = MID_Y, angle = 0;

	static float velocity = 1.0f;
	static float period = 0.0f;

	dxengine.DDFillBack(RGB16(2,2,2));

	if(KEY_DOWN(VK_ESCAPE))
	{
		ShutdownApp = 1;
	}

	if(KEY_DOWN(189))	//-
	{
		velocity -= .02f;	
	}
	
	if(KEY_DOWN(187))	//+
	{
		velocity += .02f;
	}
	
	if(KEY_DOWN(VK_UP))
	{	
	}
	
	if(KEY_DOWN(VK_DOWN))
	{
	}
	
	if(KEY_DOWN(VK_LEFT))
	{
		angle -= 2;
	}
	
	if(KEY_DOWN(VK_RIGHT))
	{	
		angle += 2;
	}	

	if(KEY_DOWN(VK_SPACE))
	{
		for(int i=0; i<10; i++)
		{
			sparky.AddSpark(0, (float)MID_X, (float)MID_Y, (UCHAR)(RAND(10)-5 + angle), (float)(1 + rand()%8), 1000, RGB16(rand()%32, rand()%32, rand()%32));
		}
	}

	dxengine.DDLockBack();

	DrawCartGraph(RGB16(0,0,18), 10, 20);
	DoSinGraph(period);	
	
	sparky.UpdateSparks();

	period += velocity;

	sprintf(buffer, "Change Velocity (-/+): %.2f,                     Spark#: %d", velocity, sparky.GetNumActive());
	dxengine.SetText(0, 20, buffer, RGB16(31, 31, 20));
	
	sparky.DrawSparks(&dxengine);

	fps.PrintRate(0, 0, RGB(20,20,20), &dxengine);
	dxengine.DDUnlockBack();
	dxengine.DDFlip();
	fps.CountFrames();
	return(1);
} 
/////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////
int Game_Shutdown()
{
	sparky.KillSparks();
	ShowCursor(TRUE);
	return(1);
} 
/////////////////////////////////////////////////////////////////////


void DrawCartGraph(DWORD color, int xs, int ys)
{
	float dx = (float)(MAX_X / xs), dy = (float)(MAX_Y / ys);
	float xi, yi;

	dxengine.Line(0, MID_Y, MAX_X, MID_Y, RGB16(0, 0, 15));
	dxengine.Line(MID_X, 0, MID_X, MAX_Y, RGB16(0, 0, 15));
	
	for(yi=0; yi<MAX_Y; yi += dy)
	{
		dxengine.HLine(MID_X - 5, MID_X + 5, (int)yi, color);
	}

	for(xi=0; xi<MAX_X; xi += dx)
	{
		dxengine.Line((int)xi, MID_Y - 5, (int)xi, MID_Y + 5, color);
	}
}


void CartPixel(float x, float y, DWORD color)
{
	dxengine.SetPixel((int)(x + (float)MID_X), (int)((-y) + (float)MID_Y), color);
}


void CartLine(float x1, float y1, float x2, float y2, DWORD color)
{
	dxengine.Line((int)(x1 + (float)MID_X), (int)((-y1) + (float)MID_Y), 
				  (int)(x2 + (float)MID_X), (int)((-y2) + (float)MID_Y), color);
}


void DoSinGraph(float period)
{
	float x, y, y1, m;

	for(x=-MID_X; x<MID_X; x++)
	{	
		y = 50 * SIN360((float)(x + period));
		CartPixel(x, y, RGB16(0, 31, 31));
	}
	
	m = COS360((float)period);

	for(x=-MID_X; x<MID_X; x++)
	{
		y1 = m * x + (50 * SIN360(period));
		CartPixel(x, y1, RGB16(31, 31, 0));	
	}

	dxengine.SetText(1152, 104, "f'(x)", RGB16(0,31,17));
	for(int i=0; i<360; i++)
	{
		CartPixel((m * 50 * COS360(i)) + 550, (m * 50 * SIN360(i)) + 400, RGB16(0,31,17));
	}

	sprintf(buffer, "Slope: %f", m);
	dxengine.SetText(0, 40, buffer, RGB16(30, 30, 30));
	dxengine.SetText(556, 50, "[Derivatives]", RGB16(31, 2, 2));
	dxengine.SetText(560, 65, "f(x) = sin(x)", RGB16(30, 30, 30));
}


void DoDistortedGraph(float period)
{
	float x, y, y1;

	for(x=-MID_X; x<MID_X; x++)
	{	
		y = 100 * SIN360(((float)x * (float)x) + period);
		y1 = 100 * SIN360(((float)(1 + x) * (float)(1 + x)) + period);
		CartLine(10 * x, y, 10 * (x + 1), y1, RGB16(0, 31, 31));
	}
	
	/*m = 200 * SIN360((float)period) * COS360((float)period);

	for(x=-MID_X; x<MID_X; x++)
	{
		y1 = m * x + (100 * SIN360((float)period * (float)period));
		CartPixel(x, y1, RGB16(31, 31, 0));
	}

	sprintf(buffer, "Slope: %f", m);
	dxengine.SetText(0, 40, buffer, RGB16(20, 20, 20));*/
}


void DoSphere(DWORD color)
{
	static float xv = 20 * COS360((int)(rand()%360));
	static float yv = 20 * SIN360((int)(rand()%360));
	static float x = 0, y = 0;
	
	int x1, y1;
	for(int i=0; i<360; i++)
	{
		x1 = (int)(60 * COS360(i));
		y1 = (int)(60 * SIN360(i));
		
		CartPixel(x + x1, y + y1, color);
	}

	x += xv;
	y += yv;

	if((x < -MID_X) || (x > MID_X)) xv = -xv;
	if((y < -MID_Y) || (y > MID_Y)) yv = -yv;
}