//By: Ben Gottemoller, august 1999

#include <headers.h>
#include <bgi.h>
#include <keyboard.h>

#define ballwidth 18
#define ballheight 18
#define shiplength 35
#define shipwidth 15
#define bulletwidth 7
#define bulletheight 7
#define E 1
#define W 2

short turretson=1;
short soundon=0;

short s1left=33, s1right=35, s1up=20, s1dwn=34, s1ab=30, s1fre=31;
short s2left=75, s2right=77, s2up=72, s2dwn=80, s2ab=39, s2fre=40;
float shp1speed=3;
float shp2speed=3;
float shp1boost, shp2boost;
short shp1score=0;
short shp2score=0;
short s1dir=E, s2dir=W;
float shp1mpg=.02, shp2mpg=.02;
float shp1fuel=140, shp2fuel=140;
float shp1rps=.9, shp2rps=.9;
float shp1ammo=140, shp2ammo=140;
float shp1dps=4, shp2dps=4;
float shp1life=140, shp2life=140;

float s1bulletx, s1bullety, s2bulletx, s2bullety;
short s1fire, s2fire, s1bulletcnt, s2bulletcnt;
float t1bulletx, t1bullety, t1fire=0, t1cnt=0, t1xm, t1ym;
float t2bulletx, t2bullety, t2fire=0, t2cnt=0, t2xm, t2ym;
float t3bulletx, t3bullety, t3fire=0, t3cnt=0, t3xm, t3ym;
float t4bulletx, t4bullety, t4fire=0, t4cnt=0, t4xm, t4ym;
float tdps=3;
int gtmin=4;

char msg1[5];
char msg2[5];

void  *ship1e, *ship1w, *ship2e, *ship2w, *ball, *s1bullet,
*s2bullet, *stats, *goal1, *goal2, *depot, *turret, *tbullet;
float sx=183, sy=262, sx2=421, sy2=262, ballx, bally;
short balltoship1, balltoship2;
short wait=100;

void qload_pics(void);
void intro(void);
void menu(void);
void shp1keys(void);
void shp2keys(void);
short what_key(void);
void main_loop(void);
void reset_all(void);
void screenupdate(void);
void _ship1(void);
void _ship2(void);
void ball_motion(void);
void goal_check(void);
void meter_update(void);
void depot_check(void);
void playingfield(void);
void bulletupdate(void);
void hit_check(void);
void death(void);
void turretfire(void);
void gettime(void);
void clearscrn();

main()
{
randomize();
bgi(VGA,VGAHI);
_setcursortype(_NOCURSOR);
settextjustify(CENTER_TEXT,CENTER_TEXT);

intro();

ballx=(mx/2)-(ballwidth/2)+1;
bally=(my/2)+(30-(ballheight/2)+1);

qload_pics();
menu();

nosound();
closegraph();
return 0;
}


void main_loop(void)
{
keyboardCapture();
keyPressed[1]=0;
bk(15);

long int _tme1, _tme2, _tme3;
int _sec, _min;
_tme1=time(NULL);
_tme2=time(NULL);
char msg[6]="     ";

_min=gtmin;
settextstyle(0, HORIZ_DIR, 2);
while(!keyPressed[1]&&(_min>-1))
{
     _tme2=time(NULL);
     _sec=(59-((_tme2-_tme1)) );
     if(_sec==0){_min-=1; _tme1=_tme2+1;}
     if((_tme2>_tme3)&&(_min>-1))
     {
     cr(LIGHTGRAY);
     outtextxy(mx/2,34,msg);
     sprintf(msg,"%d:%2d", _min, _sec);
     cr(LIGHTBLUE);
     outtextxy(mx/2,34,msg);
     }
     _tme3=time(NULL);

nosound();
_ship1();
_ship2();
if(turretson==1)turretfire();
ball_motion();
goal_check();
depot_check();
bulletupdate();
hit_check();
screenupdate();
}

nosound();
keyPressed[s1left]=0;
keyPressed[s1right]=0;
keyPressed[s1up]=0;
keyPressed[s1dwn]=0;
keyPressed[s1ab]=0;
keyPressed[s1fre]=0;

keyPressed[s2left]=0;
keyPressed[s2right]=0;
keyPressed[s2up]=0;
keyPressed[s2dwn]=0;
keyPressed[s2ab]=0;
keyPressed[s2fre]=0;

settextstyle(7, HORIZ_DIR, 9);
if(shp1score>shp2score){cr(RED); outtextxy(mx/2,my/2,"RED WINS");}
if(shp2score>shp1score){cr(BLUE); outtextxy(mx/2,my/2,"BLUE WINS");}
if(shp2score==shp1score){cr(GREEN); outtextxy(mx/2,my/2,"TIE GAME");}
settextstyle(0, HORIZ_DIR, 2);
cr(LIGHTGRAY);
outtextxy(mx/2,34,msg);
cr(LIGHTBLUE);
outtextxy(mx/2,34,"0:00");
sleep(1);
keyboardRelease();
}


void _ship1(void)
{

if(keyPressed[s1fre]&&(s1fire==0)&&(balltoship1==0)&&(shp1ammo>3))
{
if(soundon==1)sound(80);
s1fire=1;
s1bulletcnt=0;
shp1ammo-=shp1rps;
s1bulletx=(sx+(shiplength/2));
s1bullety=(sy+(shipwidth/2)-3);
}

if(keyPressed[s1ab]&&(shp1fuel>3)){shp1boost=3; shp1fuel-=.7;}else{shp1boost=0;}

if(keyPressed[s1left]&&((sx-(shp1speed+shp1boost))>=0))
{
sx-=(shp1speed+shp1boost);
s1dir=W;
shp1fuel-=shp1mpg;
}

if(keyPressed[s1right]&&((sx+shiplength+(shp1speed+shp1boost))<640))
{
sx+=(shp1speed+shp1boost);
s1dir=E;
shp1fuel-=shp1mpg;
}

if(keyPressed[s1up]&&((sy-(shp1speed+shp1boost))>60))
{
sy-=(shp1speed+shp1boost);
shp1fuel-=shp1mpg;
}

if(keyPressed[s1dwn]&&((sy+shipwidth+(shp1speed+shp1boost))<480))
{
sy+=(shp1speed+shp1boost);
shp1fuel-=shp1mpg;
}

if(balltoship1==1)s1dir=E;

if(shp1fuel<3){shp1speed=.5; shp1mpg=0;}
meter_update();
}


void _ship2(void)
{

if(keyPressed[s2fre]&&(s2fire==0)&&(balltoship2==0)&&(shp2ammo>3))
{
if(soundon==1)sound(80);
s2fire=1;
s2bulletcnt=0;
shp2ammo-=shp2rps;
s2bulletx=(sx2+(shiplength/2));
s2bullety=(sy2+(shipwidth/2)-3);
}

if(keyPressed[s2ab]&&(shp2fuel>3)){shp2boost=3; shp2fuel-=.7;}else{shp2boost=0;}

if(keyPressed[s2left]&&((sx2-(shp2speed+shp2boost))>=0))
{
sx2-=(shp2speed+shp2boost);
s2dir=W;
shp2fuel-=shp2mpg;
}

if(keyPressed[s2right]&&((sx2+shiplength+(shp2speed+shp2boost))<640))
{
sx2+=(shp2speed+shp2boost);
s2dir=E;
shp2fuel-=shp2mpg;
}

if(keyPressed[s2up]&&((sy2-(shp2speed+shp2boost))>60))
{
sy2-=(shp2speed+shp2boost);
shp2fuel-=shp2mpg;
}

if(keyPressed[s2dwn]&&((sy2+shipwidth+(shp2speed+shp2boost))<480))
{
sy2+=(shp2speed+shp2boost);
shp2fuel-=shp2mpg;
}

if(balltoship2==1)s2dir=W;

if(shp2fuel<3){shp2speed=.5; shp2mpg=0;}
meter_update();
}


void ball_motion(void)
{
if((wait==100)&&(balltoship1==0))
{
if( ((s1dir==E) && (sx+shiplength)>ballx) && ((sx+shiplength)<(ballx+ballwidth)) && (sy<(bally+ballheight)) && ((sy+shipwidth)>bally) )
{
balltoship2=0;
balltoship1=1;
shp2speed=3;
shp1speed=2;
wait=0;
}

if( (s1dir==W) && (sx<(ballx+ballwidth)) && (sx>ballx) && (sy<(bally+ballheight)) && ((sy+shipwidth)>bally) )
{
balltoship2=0;
balltoship1=1;
shp2speed=3;
shp1speed=2;
wait=0;
}
}

if((wait==100)&&(balltoship2==0))
{
if( (s2dir==W) && (sx2<(ballx+ballwidth)) && (sx2>ballx) && (sy2<(bally+ballheight)) && ((sy2+shipwidth)>bally) )
{
balltoship1=0;
balltoship2=1;
shp1speed=3;
shp2speed=2;
wait=0;
}

if( ((s2dir==E) && (sx2+shiplength)>ballx) && ((sx2+shiplength)<(ballx+ballwidth)) && (sy2<(bally+ballheight)) && ((sy2+shipwidth)>bally) )
{
balltoship1=0;
balltoship2=1;
shp1speed=3;
shp2speed=2;
wait=0;
}
}

if(wait<100)wait+=1;
}


void screenupdate(void)
{
if(s1dir==E){putimage(sx,sy,ship1e,XOR_PUT);}
else{putimage(sx,sy,ship1w,XOR_PUT);}
if(s2dir==E){putimage(sx2,sy2,ship2e,XOR_PUT);}
else{putimage(sx2,sy2,ship2w,XOR_PUT);}

if(balltoship1==1){putimage(ballx,bally,ball,XOR_PUT); ballx=(sx+shiplength); bally=(sy); putimage(ballx,bally,ball,XOR_PUT);}
if(balltoship2==1){putimage(ballx,bally,ball,XOR_PUT); ballx=(sx2-ballwidth); bally=(sy2); putimage(ballx,bally,ball,XOR_PUT);}
if(s1fire==1)putimage(s1bulletx, s1bullety, s1bullet, XOR_PUT);
if(s2fire==1)putimage(s2bulletx, s2bullety, s2bullet, XOR_PUT);

if(turretson==1)
{
if(t1fire==1)putimage(t1bulletx, t1bullety, tbullet, XOR_PUT);
if(t2fire==1)putimage(t2bulletx, t2bullety, tbullet, XOR_PUT);
if(t3fire==1)putimage(t3bulletx, t3bullety, tbullet, XOR_PUT);
if(t4fire==1)putimage(t4bulletx, t4bullety, tbullet, XOR_PUT);
}

wait_retrace();

if(s1dir==E){putimage(sx,sy,ship1e,XOR_PUT);}
else{putimage(sx,sy,ship1w,XOR_PUT);}
if(s2dir==E){putimage(sx2,sy2,ship2e,XOR_PUT);}
else{putimage(sx2,sy2,ship2w,XOR_PUT);}

if(balltoship1==1){putimage(ballx,bally,ball,XOR_PUT); ballx=(sx+shiplength); bally=(sy); putimage(ballx,bally,ball,XOR_PUT);}
if(balltoship2==1){putimage(ballx,bally,ball,XOR_PUT); ballx=(sx2-ballwidth); bally=(sy2); putimage(ballx,bally,ball,XOR_PUT);}
if(s1fire==1)putimage(s1bulletx, s1bullety, s1bullet, XOR_PUT);
if(s2fire==1)putimage(s2bulletx, s2bullety, s2bullet, XOR_PUT);

if(turretson==1)
{
if(t1fire==1)putimage(t1bulletx, t1bullety, tbullet, XOR_PUT);
if(t2fire==1)putimage(t2bulletx, t2bullety, tbullet, XOR_PUT);
if(t3fire==1)putimage(t3bulletx, t3bullety, tbullet, XOR_PUT);
if(t4fire==1)putimage(t4bulletx, t4bullety, tbullet, XOR_PUT);
}
}


void goal_check(void)
{
short ballcx=(ballx+(ballwidth/2));
short ballcy=(bally+(ballheight/2));

if((ballcx<12)&&(ballcy>241)&&(ballcy<299))
{
cr(BLUE);
outtextxy(398,30,msg2);
shp2score+=1;
sprintf(msg2,"%d",shp2score);
cr(YELLOW);
outtextxy(398,30,msg2);

balltoship1=0;
balltoship2=0;
shp1speed=3;
shp2speed=3;
putimage(ballx,bally,ball,XOR_PUT);
ballx=(mx/2)-(ballwidth/2)+1;
bally=(my/2)+(30-(ballheight/2))+1;
putimage(ballx,bally,ball,XOR_PUT);
for(int i=400; i<500; i++){delay(1); if(soundon==1)sound(i);}
nosound();
}

if((ballcx>628)&&(ballcy>241)&&(ballcy<299))
{
cr(RED);
outtextxy(240,30,msg1);
shp1score+=1;
sprintf(msg1,"%d",shp1score);
cr(YELLOW);
outtextxy(240,30,msg1);

balltoship1=0;
balltoship2=0;
shp1speed=3;
shp2speed=3;
putimage(ballx,bally,ball,XOR_PUT);
ballx=(mx/2)-(ballwidth/2)+1;
bally=(my/2)+(30-(ballheight/2)+1);
putimage(ballx,bally,ball,XOR_PUT);
for(int i=400; i<500; i++){delay(1); if(soundon==1)sound(i);}
nosound();
}
}


void meter_update(void)
{
     cr(15);
     if(shp1fuel>2)line(shp1fuel+9+37,37,shp1fuel+9+37,47);
     if(shp2fuel>2)line(shp2fuel+452+37,37,shp2fuel+452+37,47);

     if(shp1ammo>2)line(shp1ammo+9+37,24,shp1ammo+9+37,35);
     if(shp2ammo>2)line(shp2ammo+452+37,24,shp2ammo+452+37,35);

     if((shp1life>2))
     {
     setfillstyle(1,15);
     if(shp1life<140)bar(shp1life+9+36,11,140+9+36,22);
     line(shp1life+9+37,11,shp1life+9+37,22);
     if((shp1life>138)&&(shp1life<140))line(185,11,185,22);
     }

     if((shp2life>2))
     {
     setfillstyle(1,15);
     if(shp2life<140)bar(shp2life+452+36,11,140+452+36,22);
     line(shp2life+452+37,11,shp2life+452+37,22);
     if((shp2life>138)&&(shp2life<140))line(628,11,628,22);
     }
}


void playingfield(void)
{
clearscrn();
settextstyle(0, HORIZ_DIR, 0);
cr(GREEN);
pcircle((mx/2),((my/2)+30),100,100,3000,GREEN,0);
pcircle((mx/2),((my/2)+30),99,99,3000,GREEN,0);
pcircle((mx/2),((my/2)+30),101,101,3000,GREEN,0);
pcircle((mx/2),((my/2)+30),24,24,3000,GREEN,0);
pcircle((mx/2),((my/2)+30),23,23,3000,GREEN,0);
pcircle((mx/2),((my/2)+30),25,25,3000,GREEN,0);
line((mx/2)-1,58,(mx/2)-1,245);
line((mx/2),58,(mx/2),245);
line((mx/2)+1,58,(mx/2)+1,245);
line((mx/2)-1,294,(mx/2)-1,450);
line((mx/2),294,(mx/2),450);
line((mx/2)+1,294,(mx/2)+1,450);
putimage(ballx,bally,ball,XOR_PUT);
putimage(1,241,goal1,COPY_PUT);
putimage(615,241,goal2,COPY_PUT);
putimage(261,451,depot,COPY_PUT);
putimage(2,1,stats,COPY_PUT);

if(turretson==1)
{
putimage(2,60,turret,COPY_PUT);
putimage(598,60,turret,COPY_PUT);
putimage(2,439,turret,COPY_PUT);
putimage(598,439,turret,COPY_PUT);
}

cr(15);
setfillstyle(1,LIGHTGRAY);
fillellipse(mx/2,34,45,22);
outtextxy(240,8,"SCORE");
outtextxy(398,8,"SCORE");
outtextxy(28,18,"LIFE");
outtextxy(471,18,"LIFE");
outtextxy(28,31,"AMMO");
outtextxy(471,31,"AMMO");
outtextxy(28,43,"FUEL");
outtextxy(471,43,"FUEL");
cr(15);
outtextxy((mx/2),8,"TIME");
}


void depot_check(void)
{
if( ((sx+(shiplength/2))>261) && ((sx+(shiplength/2))<379) && ((sy+(shipwidth/2))>451))
{
	 if(shp1fuel<140)
     {
	 shp1mpg=.02;
	 shp1fuel+=.7;
	 if(balltoship1==0)shp1speed=3;
	 if(balltoship1==1)shp1speed=2;
	 cr(GRAY);
	 line(shp1fuel+9+36,37,shp1fuel+9+36,47);
     }

	 if(shp1ammo<140)
	 {
	 shp1ammo+=.3;
	 cr(LIGHTRED);
	 line(shp1ammo+9+36,24,shp1ammo+9+36,35);
	 }
}

if( ((sx2+(shiplength/2))>261) && ((sx2+(shiplength/2))<379) && ((sy2+(shipwidth/2))>451))
{
	 if(shp2fuel<140)
	 {
	 shp2mpg=.02;
	 shp2fuel+=.7;
	 if(balltoship2==0)shp2speed=3;
	 if(balltoship2==1)shp2speed=2;
	 cr(GRAY);
	 line(shp2fuel+452+36,37,shp2fuel+452+36,47);
	 }

	 if(shp2ammo<140)
	 {
	 shp2ammo+=.3;
	 cr(LIGHTRED);
	 line(shp2ammo+452+36,24,shp2ammo+452+36,35);
	 }
}
}


void bulletupdate(void)
{
float rnd;
if(turretson==1)rnd=100-(random(20));


if(s1bulletcnt<9)
{
	 if(s1dir==E)
	 {
	 s1bulletcnt+=1;
	 s1bulletx+=(34-random(10));
	 }

	 if(s1dir==W)
	 {
	 s1bulletcnt+=1;
	 s1bulletx-=(34-random(10));
	 }
}else{s1fire=0;}

if(s2bulletcnt<9)
{
	 if(s2dir==E)
	 {
	 s2bulletcnt+=1;
	 s2bulletx+=(34-random(10));
	 }

	 if(s2dir==W)
	 {
	 s2bulletcnt+=1;
	 s2bulletx-=(34-random(10));
	 }
}else{s2fire=0;}

if(turretson==1)
{
if((t1bulletx<(mx/2)) && (t1bullety<480))
{
    t1bulletx+=((t1xm*rnd));
    t1bullety+=((t1ym*rnd));
t1cnt+=1;
}else{t1fire=0;}

if((t2bulletx<(mx/2)) && (t2bullety>60))
{
    t2bulletx+=((t2xm*rnd));
    t2bullety-=((t2ym*rnd));
t2cnt+=1;
}else{t2fire=0;}

if((t3bulletx>(mx/2)) && (t3bullety<480))
{
    t3bulletx-=((t3xm*rnd));
    t3bullety+=((t3ym*rnd));
t3cnt+=1;
}else{t3fire=0;}

if((t4bulletx>(mx/2)) && (t4bullety>60))
{
    t4bulletx-=((t4xm*rnd));
    t4bullety-=((t4ym*rnd));
t4cnt+=1;
}else{t4fire=0;}

}

}


void hit_check(void)
{

if( ((s2bullety+3.5)>sy) && ((s2bullety+3.5)<(sy+shipwidth)) )
{
	 if( ((s2bulletx+3.5)>sx) && ((s2bulletx+3.5)<(sx+shiplength)) )
	 {
     if(s2fire==1)shp1life-=shp1dps;
	 s2fire=0;
	 }
}

if( ((s1bullety+3.5)>sy2) && ((s1bullety+3.5)<(sy2+shipwidth)) )
{
	 if( ((s1bulletx+3.5)>sx2) && ((s1bulletx+3.5)<(sx2+shiplength)) )
	 {
	 if(s1fire==1)shp2life-=shp2dps;
	 s1fire=0;
	 }
}

if(turretson==1)
{                                                       
if( ((t1bullety+3.5)>(sy2-5)) && ((t1bullety+3.5)<(sy2+shipwidth+5)) )
{
     if( ((t1bulletx+3.5)>sx2) && ((t1bulletx+3.5)<(sx2+shiplength)) )
	 {
     if(t1fire==1)shp2life-=tdps;
     t1fire=0;
	 }
}

if( ((t2bullety+3.5)>(sy2-5)) && ((t2bullety+3.5)<(sy2+shipwidth+5)) )
{
     if( ((t2bulletx+3.5)>sx2) && ((t2bulletx+3.5)<(sx2+shiplength)) )
	 {
     if(t2fire==1)shp2life-=tdps;
     t2fire=0;
	 }
}

if( ((t3bullety+3.5)>(sy-5)) && ((t3bullety+3.5)<(sy+shipwidth+5)) )
{
     if( ((t3bulletx+3.5)>sx) && ((t3bulletx+3.5)<(sx+shiplength)) )
	 {
     if(t3fire==1)shp1life-=tdps;
     t3fire=0;
	 }
}

if( ((t4bullety+3.5)>(sy-5)) && ((t4bullety+3.5)<(sy+shipwidth+5)) )
{
     if( ((t4bulletx+3.5)>sx) && ((t4bulletx+3.5)<(sx+shiplength)) )
	 {
     if(t4fire==1)shp1life-=tdps;
     t4fire=0;
	 }
}
}

if( ((s1bullety+3.5)>bally) && ((s1bullety+3.5)<(bally+ballheight)) )
{
	 if( ((s1bulletx+3.5)>ballx) && ((s1bulletx+3.5)<(ballx+ballwidth)) )
	 {
	 s1fire=0;
	 putimage(ballx,bally,ball,XOR_PUT);
     if(s1dir==E)ballx+=15;
     if(s1dir==W)ballx-=15;
	 putimage(ballx,bally,ball,XOR_PUT);
	 }
}

if( ((s2bullety+3.5)>bally) && ((s2bullety+3.5)<(bally+ballheight)) )
{
	 if( ((s2bulletx+3.5)>ballx) && ((s2bulletx+3.5)<(ballx+ballwidth)) )
	 {
	 s2fire=0;
	 putimage(ballx,bally,ball,XOR_PUT);
     if(s2dir==E)ballx+=15;
     if(s2dir==W)ballx-=15;
	 putimage(ballx,bally,ball,XOR_PUT);
	 }
}

death();
}


void death(void)
{
int a;
if(shp1life<3)
{
s2fire=0;
cr(BLUE);
outtextxy(398,30,msg2);
shp2score+=1;
sprintf(msg2,"%d",shp2score);
cr(YELLOW);
outtextxy(398,30,msg2);

if(s2dir==E)putimage(sx2,sy2,ship2e,XOR_PUT);
if(s2dir==W)putimage(sx2,sy2,ship2w,XOR_PUT);

	 if(balltoship1)
	 {
	 balltoship1=0;
	 putimage(ballx,bally,ball,XOR_PUT);
	 ballx=(mx/2)-(ballwidth/2)+1;
	 bally=(my/2)+(30-(ballheight/2)+1);
	 putimage(ballx,bally,ball,XOR_PUT);
	 }

for(a=0; a<30; a++)
{
if(soundon==1)sound(5*a);
pcircle((sx+(shiplength/2)),(sy+(shipwidth/2)),a,a,random(100),random(16),0);
delay(10);
}

setfillstyle(1,LIGHTBLUE);
bar(11+37,11,185,22);
shp1life=140;

setfillstyle(1,LIGHTRED);
bar(11+37,24,185,35);
shp1ammo=140;

setfillstyle(1,GRAY);
bar(11+37,37,185,47);
shp1fuel=140;
shp1speed=3;
shp1mpg=.02;

if(s2dir==E)putimage(sx2,sy2,ship2e,XOR_PUT);
if(s2dir==W)putimage(sx2,sy2,ship2w,XOR_PUT);

sx=183; sy=262;
}

if(shp2life<3)
{
s1fire=0;
cr(RED);
outtextxy(240,30,msg1);
shp1score+=1;
sprintf(msg1,"%d",shp1score);
cr(YELLOW);
outtextxy(240,30,msg1);

if(s1dir==E)putimage(sx,sy,ship1e,XOR_PUT);
if(s1dir==W)putimage(sx,sy,ship1w,XOR_PUT);

	 if(balltoship2)
	 {
	 balltoship2=0;
	 putimage(ballx,bally,ball,XOR_PUT);
	 ballx=(mx/2)-(ballwidth/2)+1;
	 bally=(my/2)+(30-(ballheight/2)+1);
	 putimage(ballx,bally,ball,XOR_PUT);
	 }

for(a=0; a<30; a++)
{
if(soundon==1)sound(5*a);
pcircle((sx2+(shiplength/2)),(sy2+(shipwidth/2)),a,a,random(100),random(16),0);
delay(10);
}

setfillstyle(1,LIGHTBLUE);
bar(454+37,11,628,22);
shp2life=140;

setfillstyle(1,LIGHTRED);
bar(454+37,24,628,35);
shp2ammo=140;

setfillstyle(1,GRAY);
bar(454+37,37,628,47);
shp2fuel=140;
shp2speed=3;
shp2mpg=.02;

if(s1dir==E)putimage(sx,sy,ship1e,XOR_PUT);
if(s1dir==W)putimage(sx,sy,ship1w,XOR_PUT);
sx2=421; sy2=262;
}
}

void intro(void)
{
void *copyright=qload("crght.q");
bk(0);
for(int a=0; a<540; a++)
{
pcircle((mx/2)+200,my/2,a,a,random(300),random(15),0);
delay(5);
}
settextstyle(7, HORIZ_DIR, 9);
cr(LIGHTGRAY);
outtextxy(mx/2,my/3,"DEEP SKY");
settextstyle(5, HORIZ_DIR, 1);
outtextxy(mx-110,my-15,"By: Ben Gottemoller 1999");
putimage(390,461,copyright,COPY_PUT);
sleep(2);
getch();
clearscrn();
}


void menu(void)
{
void *_bar, *toggle;
void *wormhole;
_bar=qload("bar.q");
toggle=qload("toggle.q");
wormhole=qload("eddy.q");
int redraw=1;
int barx, bary;
int loop=1;
char cont;
long int t1, t2;
t1=time(NULL);

while(loop)
{
t2=time(NULL);

if((t2-t1)>=30)
{
clearscrn();
intro();
sleep(1);
redraw=1;
}

if(redraw==1)
{
t1=time(NULL);
bk(0);
settextstyle(0, HORIZ_DIR, 0);
cr(GRAY);
outtextxy(mx-130,my-12,"By: Ben Gottemoller (c) 1999");
putimage(160,80,wormhole,COPY_PUT);
settextstyle(7, HORIZ_DIR, 3);
cr(15);
outtextxy(mx/2,80,"Start Game");
outtextxy(mx/2,180,"Controls");
outtextxy(mx/2,280,"Options");
outtextxy(mx/2,380,"Quit Game");
cont=NULL;
barx=160; bary=60;
putimage(barx,bary,_bar,XOR_PUT);
redraw=0;
}

cont=NULL;
if(kbhit()){cont=getch();}
delay(30);

if((cont==UP_ARROW))
{
if(soundon==1)sound(100);
t1=time(NULL);
cont=NULL;
putimage(barx,bary,_bar,XOR_PUT);
bary-=100;
if(bary<60)bary=360;
putimage(barx,bary,_bar,XOR_PUT);
}

if((cont==DN_ARROW))
{
if(soundon==1)sound(100);
t1=time(NULL);
cont=NULL;
putimage(barx,bary,_bar,XOR_PUT);
bary+=100;
if(bary>360)bary=60;
putimage(barx,bary,_bar,XOR_PUT);
}

if((cont==ENTER_KEY))
{
if(soundon==1)sound(100);
cont=NULL;
	if(bary==60)
	{
	nosound();
    clearscrn();
	reset_all();
	nosound();
	playingfield();
	main_loop();
	sleep(1);
	cont=NULL;
    clearscrn();
	redraw=1;
	t1=time(NULL);
	}

	if(bary==160)
	{
	nosound();
	sleep(1);
	fflush(stdin);
	cont=NULL;
	char message[20]="                    ";
    clearscrn();
	putimage(160,80,wormhole,COPY_PUT);
	settextjustify(0,0);
	settextstyle(0, HORIZ_DIR, 1);
	cr(RED);
	outtextxy(1,10,"Red Default:");
	outtextxy(1,20,"Move Left: F");
	outtextxy(1,30,"Move Right: H");
	outtextxy(1,40,"Move Up: T");
	outtextxy(1,50,"Move Down: G");
	outtextxy(1,60,"Afterburner: A");
	outtextxy(1,70,"Fire: S");
	cr(BLUE);
	outtextxy(530,10,"Blue Default:");
	sprintf(message,"Move Left: %c", 27);
	outtextxy(530,20,message);
	sprintf(message,"Move Right: %c", 26);
	outtextxy(530,30,message);
	sprintf(message,"Move Up: %c", 24);
	outtextxy(530,40,message);
	sprintf(message,"Move Down: %c", 25);
	outtextxy(530,50,message);
	outtextxy(530,60,"Afterbuner: ;");
	outtextxy(530,70,"Fire: '");

	cr(15);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	settextstyle(7, HORIZ_DIR, 3);
	outtextxy(mx/2,150,"Redefine Red");
	outtextxy(mx/2,250,"Redefine Blue");
	outtextxy(mx/2,350,"Back");
	int barx2=160; int bary2=130;
	putimage(barx2,bary2,_bar,XOR_PUT);
	char cont2=NULL;
	int loop2=1;

	while(loop2)
	{
	cont2=NULL;
	delay(30);
	if(kbhit()){cont2=getch();}

	if((cont2==UP_ARROW))
	{
	if(soundon==1)sound(100);
	cont2=NULL;
	putimage(barx2,bary2,_bar,XOR_PUT);
	bary2-=100;
	if(bary2<130)bary2=330;
	putimage(barx2,bary2,_bar,XOR_PUT);
	}

	if((cont2==DN_ARROW))
	{
	if(soundon==1)sound(100);
	cont2=NULL;
	putimage(barx2,bary2,_bar,XOR_PUT);
	bary2+=100;
	if(bary2>330)bary2=130;
	putimage(barx2,bary2,_bar,XOR_PUT);
	}

	if((cont2==ENTER_KEY))
	{
	if(soundon==1)sound(100);
	nosound();
		if(bary2==130)
		{
		sleep(1);
		cont2=NULL;
        clearscrn();
		nosound();
		shp1keys();
		putimage(160,80,wormhole,COPY_PUT);
		settextjustify(0,0);
		settextstyle(0, HORIZ_DIR, 1);
		cr(RED);
		outtextxy(1,10,"Red Default:");
		outtextxy(1,20,"Move Left: F");
		outtextxy(1,30,"Move Right: H");
		outtextxy(1,40,"Move Up: T");
		outtextxy(1,50,"Move Down: G");
		outtextxy(1,60,"Afterburner: A");
		outtextxy(1,70,"Fire: S");
		cr(BLUE);
		outtextxy(530,10,"Blue Default:");
		sprintf(message,"Move Left: %c", 27);
		outtextxy(530,20,message);
		sprintf(message,"Move Right: %c", 26);
		outtextxy(530,30,message);
		sprintf(message,"Move Up: %c", 24);
		outtextxy(530,40,message);
		sprintf(message,"Move Down: %c", 25);
		outtextxy(530,50,message);
		outtextxy(530,60,"Afterbuner: ;");
		outtextxy(530,70,"Fire: '");

		cr(15);
		settextjustify(CENTER_TEXT,CENTER_TEXT);
		settextstyle(7, HORIZ_DIR, 3);
		outtextxy(mx/2,150,"Redefine Red");
		outtextxy(mx/2,250,"Redefine Blue");
		outtextxy(mx/2,350,"Back");
		barx2=160; bary2=130;
		putimage(barx2,bary2,_bar,XOR_PUT);
		cont2=NULL;
		sleep(1);
		}

		if(bary2==230)
		{
		sleep(1);
		cont2=NULL;
        clearscrn();
		nosound();
		shp2keys();
		putimage(160,80,wormhole,COPY_PUT);
		settextjustify(0,0);
		settextstyle(0, HORIZ_DIR, 1);
		cr(RED);
		outtextxy(1,10,"Red Default:");
		outtextxy(1,20,"Move Left: F");
		outtextxy(1,30,"Move Right: H");
		outtextxy(1,40,"Move Up: T");
		outtextxy(1,50,"Move Down: G");
		outtextxy(1,60,"Afterburner: A");
		outtextxy(1,70,"Fire: S");
		cr(BLUE);
		outtextxy(530,10,"Blue Default:");
		sprintf(message,"Move Left: %c", 27);
		outtextxy(530,20,message);
		sprintf(message,"Move Right: %c", 26);
		outtextxy(530,30,message);
		sprintf(message,"Move Up: %c", 24);
		outtextxy(530,40,message);
		sprintf(message,"Move Down: %c", 25);
		outtextxy(530,50,message);
		outtextxy(530,60,"Afterbuner: ;");
		outtextxy(530,70,"Fire: '");

		cr(15);
		settextjustify(CENTER_TEXT,CENTER_TEXT);
		settextstyle(7, HORIZ_DIR, 3);
		outtextxy(mx/2,150,"Redefine Red");
		outtextxy(mx/2,250,"Redefine Blue");
		outtextxy(mx/2,350,"Back");
		barx2=160; bary2=130;
		putimage(barx2,bary2,_bar,XOR_PUT);               
		cont=NULL;
		sleep(1);
		}

		if(bary2==330)
		{
		nosound();
		sleep(1);
        clearscrn();
		loop2=0;
		redraw=1;
		t1=time(NULL);
		}       
	}
	nosound();
	}
	sleep(1);
    clearscrn();
	redraw=1;
	t1=time(NULL);
	}

	if(bary==260)
	{
	if(soundon==1)sound(100);
	nosound();
	sleep(1);
	fflush(stdin);
	cont=NULL;
    clearscrn();
	putimage(160,80,wormhole,COPY_PUT);
	if(turretson==1)putimage(400,70,toggle,XOR_PUT);
	if(soundon==1)putimage(400,170,toggle,XOR_PUT);
	cr(15);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	settextstyle(7, HORIZ_DIR, 3);
	outtextxy(mx/2,80,"Turrets");
	outtextxy(mx/2,180,"Sound");
	outtextxy(mx/2,280,"Game Length");
	outtextxy(mx/2,380,"Back");
	int barx3=160; int bary3=60;
	putimage(barx3,bary3,_bar,XOR_PUT);
	char cont3=NULL;
	int loop3=1;

	while(loop3)
	{
	nosound();
	cont3=NULL;
	delay(30);
	if(kbhit()){cont3=getch();}

	if((cont3==UP_ARROW))
	{
	if(soundon==1)sound(100);
	cont3=NULL;
	putimage(barx3,bary3,_bar,XOR_PUT);
	bary3-=100;
	if(bary3<60)bary3=360;
	putimage(barx3,bary3,_bar,XOR_PUT);
	}

	if((cont3==DN_ARROW))
	{
	if(soundon==1)sound(100);
	cont3=NULL;
	putimage(barx3,bary3,_bar,XOR_PUT);
	bary3+=100;
	if(bary3>360)bary3=60;
	putimage(barx3,bary3,_bar,XOR_PUT);
	}

	if((cont3==ENTER_KEY))
	{
	if(soundon==1)sound(100);
	if(bary3==60)
	{
	putimage(400,70,toggle,XOR_PUT);
	if(turretson==1){turretson=0;}else{turretson=1;}
	delay(50);
	}

	if(bary3==160)
	{
	putimage(400,170,toggle,XOR_PUT);
	if(soundon==1){soundon=0;}else{soundon=1;}
	delay(50);
	}

	if(bary3==260)
	{
	nosound();
	gettime();
	sleep(1);
	nosound();
    clearscrn();
	fflush(stdin);
	putimage(160,80,wormhole,COPY_PUT);
	if(turretson==1)putimage(400,70,toggle,XOR_PUT);
	if(soundon==1)putimage(400,170,toggle,XOR_PUT);
	cr(15);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	settextstyle(7, HORIZ_DIR, 3);
	outtextxy(mx/2,80,"Turrets");
	outtextxy(mx/2,180,"Sound");
	outtextxy(mx/2,280,"Game Length");
	outtextxy(mx/2,380,"Back");
	barx3=160; bary3=60;
	putimage(barx3,bary3,_bar,XOR_PUT);
	cont3=NULL;
	loop3=1;
	}

	if(bary3==360)
	{
	nosound();
	sleep(1);
    clearscrn();
	loop3=0;
	redraw=1;
	t1=time(NULL);
	}
	}

	}
	}
	

	if(bary==360)
	{
    clearscrn();
	loop=0;
	}
}
nosound();
}
clearscrn();
}


void qload_pics(void)
{
ship1e=qload("ship1e.q");
ship1w=qload("ship1w.q");
ship2e=qload("ship2e.q");
ship2w=qload("ship2w.q");
ball=qload("ball.q");
s1bullet=qload("s1bullet.q");
s2bullet=qload("s2bullet.q");
stats=qload("stats.q");
goal1=qload("goal1.q");
goal2=qload("goal2.q");
depot=qload("refuel.q");
turret=qload("turret.q");
tbullet=qload("tbullet.q");
}

void turretfire(void)
{

if( (t1fire==0) && ((sx2+(shiplength/2))<(mx/2)) )
{
if(soundon==1)sound(100);
t1fire=1;
t1cnt=0;
t1xm=abs((sx2+(shiplength/2))-23);
t1ym=abs((sy2+(shipwidth/2))-80);

while((t1xm>1)||(t1ym>1)){t1xm=(t1xm/10); t1ym=(t1ym/10);}

t1bulletx=23;
t1bullety=80;
}
if( (t2fire==0) && ((sx2+(shiplength/2))<(mx/2)) )
{
if(soundon==1)sound(120);
t2fire=1;
t2cnt=0;
t2xm=abs((sx2+(shiplength/2))-23);
t2ym=abs((sy2+(shipwidth/2))-459);
while((t2xm>1)||(t2ym>1)){t2xm=(t2xm/10); t2ym=(t2ym/10);}
t2bulletx=23;
t2bullety=459;
}

if( (t3fire==0) && ((sx+(shiplength/2))>(mx/2)) )
{
if(soundon==1)sound(100);
t3fire=1;
t3cnt=0;
t3xm=abs((sx+(shiplength/2))-619);
t3ym=abs((sy+(shipwidth/2))-80);
while((t3xm>1)||(t3ym>1)){t3xm=(t3xm/10); t3ym=(t3ym/10);}
t3bulletx=619;
t3bullety=80;
}
if( (t4fire==0) && ((sx+(shiplength/2))>(mx/2)) )
{
if(soundon==1)sound(120);
t4fire=1;
t4cnt=0;
t4xm=abs((sx+(shiplength/2))-619);
t4ym=abs((sy+(shipwidth/2))-459);
while((t4xm>1)||(t4ym>1)){t4xm=(t4xm/10); t4ym=(t4ym/10);}
t4bulletx=619;
t4bullety=459;
}

}

void reset_all(void)
{
stats=qload("stats.q");
shp1speed=3;
shp2speed=3;
shp1boost=0;
shp2boost=0;
shp1score=0;
shp2score=0;
s1dir=E;
s2dir=W;
shp1mpg=.02;
shp2mpg=.02;
shp1fuel=140;
shp2fuel=140;
shp1rps=.9;
shp2rps=.9;
shp1ammo=140;
shp2ammo=140;
shp1life=140;
shp2life=140;
s1bulletx=0;
s1bullety=0;
s2bulletx=0;
s2bullety=0;
s1fire=0;
s2fire=0;
s1bulletcnt=0;
s2bulletcnt=0;
sx=183;
sy=262;
sx2=421;
sy2=262;
ballx=(mx/2)-(ballwidth/2)+1;
bally=(my/2)+(30-(ballheight/2)+1);
balltoship1=0;
balltoship2=0;
wait=100;
t1bulletx=0; t1bullety=0; t1fire=0; t1cnt=0;
t2bulletx=0; t2bullety=0; t2fire=0; t2cnt=0;
t3bulletx=0; t3bullety=0; t3fire=0; t3cnt=0;
t4bulletx=0; t4bullety=0; t4fire=0; t4cnt=0;
}

void shp1keys(void)
{
cr(RED);
sleep(2);
delay(100);
fflush(stdin);
outtextxy(mx/2,my/2,"Left: ");
s1left=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Right: ");
s1right=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Up: ");
s1up=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Down: ");
s1dwn=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"AfterBurner: ");
s1ab=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Fire: ");
s1fre=what_key();
cleardevice();
sleep(2);
}

void shp2keys(void)
{
cr(BLUE);
sleep(2);
delay(100);
fflush(stdin);
outtextxy(mx/2,my/2,"Left: ");
s2left=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Right: ");
s2right=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Up: ");
s2up=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Down: ");
s2dwn=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"AfterBurner: ");
s2ab=what_key();
cleardevice();
sleep(1);
outtextxy(mx/2,my/2,"Fire: ");
s2fre=what_key();
cleardevice();
sleep(2);
}


short what_key(void)
{
short key=0;
keyboardCapture();
delay(200);
key=0;
haveKey=0;
while((key==0)&&(!haveKey))
{
for(int cnt=0; cnt<100; cnt++)
{
if(keyPressed[cnt]){key=cnt; keyPressed[cnt]=0;}
keyPressed[cnt]=0;
}
haveKey=0;
}
keyboardRelease();
return key;
}


void gettime(void)
{
short lcnt, loop4, sqx, sqy;
char cont4=NULL;
char mg[10]="          ";
void *sq;

sq=qload("sq.q");
clearscrn();
loop4=1;
setfillstyle(1,GRAY);
bar(109, 213, 529, 267);
cr(LIGHTGRAY);
rectangle(109, 213, 529, 267);

gtmin=1;
sqx=110; sqy=214;
putimage(sqx,sqy,sq,XOR_PUT);
cr(15);
sprintf(mg,"%d Min", gtmin);
outtextxy(mx/2,my/2,mg);

	while(loop4)
	{
	nosound();
	cont4=NULL;
	delay(30);
	if(kbhit()){cont4=getch();}

	if((cont4==LT_ARROW)&&(sqx>110))
	{
	if(soundon==1)sound(100);
	cont4=NULL;
	putimage(sqx,sqy,sq,XOR_PUT);
	sqx-=14;
	putimage(sqx,sqy,sq,XOR_PUT);
	cr(GRAY);
	outtextxy(mx/2,my/2,mg);
	gtmin-=1;
	cr(15);
	sprintf(mg,"%d Min", gtmin);
	outtextxy(mx/2,my/2,mg);
	}

	if((cont4==RT_ARROW)&&(sqx<516))
	{
	if(soundon==1)sound(100);
	cont4=NULL;
	putimage(sqx,sqy,sq,XOR_PUT);
	sqx+=14;
	putimage(sqx,sqy,sq,XOR_PUT);
	cr(GRAY);
	outtextxy(mx/2,my/2,mg);
	gtmin+=1;
	cr(15);
	sprintf(mg,"%d Min", gtmin);
	outtextxy(mx/2,my/2,mg);
	}

	if((cont4==ENTER_KEY))
	{
	if(soundon==1)sound(100);
	loop4=0;
	gtmin-=1;
	}

	}
nosound();
}


void clearscrn(void)
{
int color;
float x, y, incr;

color=getbkcolor();
setcolor(color);

for(incr=0; incr<4; incr++)
{
for(x=0; x<=mx; x+=4)
{
line(x+incr,0,x+incr,my);
}

for(y=0; y<=my; y+=4)
{
line(0,y+incr,mx,y+incr);
}
}

cleardevice();
}


