//By: Ben Gottemoller 1999

#include <tyac.h>
#include <graphics.h>
#include <math.h>

#define SVGA 11   //GraphDriver
#define SVGA1 0   //GraphMode 320X200X256
#define SVGA2 1   //GraphMode 640X400X256
#define SVGA3 2   //GraphMode 640X480X256
#define SVGA4 3   //GraphMode 800X600X256
#define SVGA5 4   //GraphMode 1024X768X256
#define bk(int) setbkcolor(int)
#define cr(int) setcolor(int)
#define VRETRACE 0x08
#define INPUT_STATUS 0x03da
#define PI2 6.28318530718
#define left 0
#define right 1
#define up 2
#define down 3

float mx, my;
int huge detectVESA(void);
void bgi(int GraphDriver, int GraphMode);
void wait_retrace(void);
char* type(int x, int y, int style, int size);
void pcircle(int x, int y, int xradius, int yradius, int dots, int color, int cleanup);
void fill(int x, int y, int color);
void qsave(char savas[20], int lt, int rt, int tp, int btm);
void* qload(char file[20]);        
void _save(char savas[20], int sb_l, int sb_r, int sb_t, int sb_b);
int* _load(int x, int y, char file[20]);
void flip(int sb_l,int sb_r,int sb_t,int sb_b,int dir);

void bgi(int GraphDriver, int GraphMode)
{

if(GraphDriver==SVGA)
{
GraphDriver=installuserdriver("bgi256v2", detectVESA);
}

initgraph(&GraphDriver, &GraphMode, "");
initgraph(&GraphDriver, &GraphMode, "");

if(graphresult()!=0)
{
printf("\n%s", grapherrormsg(graphresult()));
getch();
exit(0);
}

mx=getmaxx();
my=getmaxy();
cleardevice();
}

int huge detectVESA(void)
{
return(2);
}

void wait_retrace(void)
{
while((inp(INPUT_STATUS)&VRETRACE)){} 
while(!(inp(INPUT_STATUS)&VRETRACE)){}
}


char* type(int x, int y, int style, int size)
{
//style,dir,size
 settextstyle(style, HORIZ_DIR, size);
char message[500];  
char k[1]; 
char bffr[1]; 
int th=textheight("H"), cnt=0;
int bkclr=getbkcolor();

while(1)
{
k[0]=NULL;
k[1]=NULL;

k[0]=getch();
if(k[0]==ENTER_KEY)break;
if(cnt<500){message[cnt]=k[0];}
cnt+=1;

	if((k[0]==8)&&(cnt>0))
	{
	bffr[0]=NULL; bffr[1]=NULL;
	int prevcol=getcolor();
	cnt-=2;
	bffr[0]=message[cnt];
	x-=textwidth(bffr);
	cr(bkclr);
	outtextxy(x,y,bffr);
	k[0]=NULL;
	cr(prevcol);
	}

outtextxy(x, y, k);
x+=textwidth(k);
if(x>mx){x=0; y+=(th);}
if(y>(my-th)){x=0; y=0;}
}
for(int b=cnt; b<=500; b++){message[b]=NULL;}

return message;
}



void pcircle(int x, int y, int xradius, int yradius, int dots, int color, int cleanup)
{
int _cnt;

	if(cleanup==1&&dots<=7000)
	{
	int __x1[7000], __y1[7000];

        for(_cnt=0; _cnt<dots; _cnt++)
		{
		putpixel(__x1[_cnt], __y1[_cnt], 0);
        putpixel(__x1[_cnt]=(xradius*cos(_cnt*PI2/dots)+x+.5),__y1[_cnt]=(yradius*sin(_cnt*PI2/dots)+y+.5),color);
		}
	}

	if(cleanup!=1||dots>7000)
	{
        for(_cnt=0; _cnt<dots; _cnt++)
		{
        putpixel((xradius*cos(_cnt*PI2/dots)+x+.5),(yradius*sin(_cnt*PI2/dots)+y+.5),color);
		}
	}
}


void fill(int x, int y, int color)
{
int pixcolor, direction, v, h, cnt, l, r, t, b, bkcol;
randomize();

while((!kbhit()))
{
direction=rand()%4;
l=getpixel((x-1), y);
r=getpixel((x+1), y);
t=getpixel(x, (y-1));
b=getpixel(x, (y+1));

if(direction==left)
{
	if((l!=0)&&(l!=color)){direction=rand()%4; continue;}
	while((l==0)||(l==color)){x-=1; putpixel(x, y, color); l=getpixel((x-1), y); if(random(rand()%10)==2)break;}
}

if(direction==right)
{
	if((r!=0)&&(r!=color)){direction=rand()%4; continue;}
	while((r==0)||(r==color)){x+=1; putpixel(x, y, color); r=getpixel((x+1), y); if(random(rand()%10)==2)break;}
}

if(direction==up)
{
	if((t!=0)&&(t!=color)){direction=rand()%4; continue;}
	while((t==0)||(t==color)){y-=1; putpixel(x, y, color); t=getpixel(x, (y-1)); if(random(rand()%10)==2)break;}
}

if(direction==down)
{
	if((b!=0)&&(b!=color)){direction=rand()%4; continue;}
	while((b==0)||(b==color)){y+=1; putpixel(x, y, color); b=getpixel(x, (y+1)); if(random(rand()%10)==2)break;}
}

}
}


void qsave(char savas[20], int lt, int rt, int tp, int btm)
{
FILE *fp;
void *pic;
unsigned size;

size=imagesize(lt, tp, rt, btm);
pic=malloc(size);
getimage(lt, tp, rt, btm, pic);

fp=fopen(savas, "wb");
fwrite(&size, sizeof(size), 1, fp);
fwrite(pic, size, 1, fp);
fclose(fp);
free(pic);
}


void* qload(char file[20])
{
FILE *fp;
void *pic;
unsigned int size;

fp=fopen(file, "rb");
fread(&size, sizeof(size), 1, fp);
pic=malloc(size);
fread(pic, size, 1, fp);
fclose(fp);
return pic;
}


void _save(char savas[20], int sb_l, int sb_r, int sb_t, int sb_b)
{
FILE *fp;
int x, y;

fp=fopen(savas, "w");
fprintf(fp, "%d %d %d %d ", sb_l, sb_r, sb_t, sb_b);

for(x=sb_l+1; x<sb_r; x++)
{
     for(y=sb_t+1; y<sb_b; y++)
     {
     fprintf(fp, "%d ", getpixel(x,y));
     }
}
fclose(fp);
}


int* _load(int x, int y, char file[20])
{
int *lrtb;
FILE *fp;
int sb_l, sb_r, sb_t, sb_b;
int cx,cy;
int xdist, ydist;

fp=fopen(file, "r");
fscanf(fp, "%d %d %d %d ", &sb_l, &sb_r, &sb_t, &sb_b);

xdist=abs(sb_l-sb_r);
ydist=abs(sb_t-sb_b);
sb_l=x;
sb_r=(x+xdist);
sb_t=y;
sb_b=(y+ydist);

for(cx=sb_l+1; cx<sb_r; cx++)
{
     for(cy=sb_t+1; cy<sb_b; cy++)
     {
     int tempcolor;
     fscanf(fp, "%d ", &tempcolor);
     putpixel(cx, cy, tempcolor);
     }
}
fclose(fp);
lrtb[0]=sb_l;
lrtb[1]=sb_r;
lrtb[2]=sb_t;
lrtb[3]=sb_b;
return lrtb;
}


void flip(int sb_l, int sb_r, int sb_t, int sb_b, int dir)
{
FILE *fp;
int x,y;

fp=fopen("buffer", "w");
fprintf(fp, "%d %d %d %d ", sb_l, sb_r, sb_t, sb_b);
for(x=sb_l+1; x<sb_r; x++)
{
	for(y=sb_t+1; y<sb_b; y++)
	{
	fprintf(fp, "%d ", getpixel(x,y));
	}
}
fclose(fp);

if(dir==1) //horizontal
{

fp=fopen("buffer", "r");
fscanf(fp, "%d %d %d %d ", &sb_l, &sb_r, &sb_t, &sb_b);
for(x=sb_r-1; x>sb_l; x--)
{
	for(y=sb_t+1; y<sb_b; y++)
	{
	int tempcolor;
	fscanf(fp, "%d ", &tempcolor);
	putpixel(x, y, tempcolor);
	}
}
fclose(fp);

}


if(dir==2) //vertical
{
fp=fopen("buffer", "r");
fscanf(fp, "%d %d %d %d ", &sb_l, &sb_r, &sb_t, &sb_b);
for(x=sb_l+1; x<sb_r; x++)
{
	for(y=sb_b-1; y>sb_t; y--)
	{
	int tempcolor;
	fscanf(fp, "%d ", &tempcolor);
	putpixel(x, y, tempcolor);
	}
}
fclose(fp);
}
remove("buffer");

}
