//
//This was originally the Matrices tutoriel for Microsoft DirectX 8
//I spent a few days tearing it apart, and fooling around until I understood
//it all pretty well. Be warned, there's not much ms code left and all my stuff
//is pretty messy. This is in fact, my first d3d app ever.
//By: Ben Gottemoller
//gottemol@uiuc.edu
//
#include <d3dx8.h>
#include <mmsystem.h>
//#include "D3DFont.h"

#define KEY_DOWN(vk_code)	((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define RADIANS(degrees)	(degrees * (3.14159f/180.0f))		
const double PI      = 3.14159265358979323846264338327950288419716939937510f;
const double PI2     = PI * 2;
const double RADIAN  = PI / 180.0f; 
const double DEGREE360 = 180.0f / PI;

const double RADIAN256 = PI / 128.0f;
const double DEGREE256 = 128.0f / PI;

#define SIN360(theta)	(float)sin((double)theta * RADIAN) 
#define COS360(theta)	(float)cos((double)theta * RADIAN) 
#define TAN360(theta)	(float)tan((double)theta * RADIAN)

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768
#define MID_X (SCREEN_WIDTH/2)
#define MID_Y (SCREEN_HEIGHT/2)


//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------
LPDIRECT3D8             g_pD3D       = NULL; // Used to create the D3DDevice
LPDIRECT3DDEVICE8       g_pd3dDevice = NULL; // Our rendering device
LPDIRECT3DVERTEXBUFFER8 g_pVB        = NULL; // Buffer to hold vertices
LPDIRECT3DVERTEXBUFFER8 g_pVB2       = NULL;
LPDIRECT3DTEXTURE8      g_pTexture   = NULL;
LPD3DXFONT				g_pD3DXFont;

// A structure for our custom vertex type
struct CUSTOMVERTEX
{
	D3DXVECTOR3 position;  
	D3DXVECTOR3 normal;
	D3DCOLOR    diffuse;
	D3DCOLOR    specular;
	FLOAT       tu, tv;
};

// Our custom FVF, which describes our custom vertex structure
#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_SPECULAR | D3DFVF_TEX1)

#define NumVertices (360)

bool b_texture = 0;

//LPD3DXFONT g_pD3DXFont; 	
//HFONT hFont = CreateFont(28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, PROOF_QUALITY, 0, "Arial"); 	
//D3DXCreateFont(d3dDevice, hFont, &g_pD3DXFont); 
//RECT rTemp = {0, 0, 800, 200}; 	
//g_pD3DXFont->DrawText("D3DXCreateFont example", -1, &rTemp, DT_LEFT, D3DCOLOR_RGBA(255, 120, 120, 255)); 


class CFrameRate
{
public:
	CFrameRate();

	void CountFrames(void);
	int GetRate(void);

private:

	int FrameRate;
	int FrameCount;
	int FrameCount0;
	DWORD FrameTime;
	DWORD FrameTime0;
};

CFrameRate::CFrameRate()
{
	FrameRate = 0;
	FrameCount = 0;
	FrameCount0 = 0;
	FrameTime = 0;
	FrameTime0 = 0;
}


void CFrameRate::CountFrames(void)
{
	FrameCount++;
	FrameTime = GetTickCount();

	if (FrameTime - FrameTime0 > 1000)
	{
		FrameRate = (FrameCount - FrameCount0) * 1000 / (FrameTime - FrameTime0);
		FrameTime0 = FrameTime;
		FrameCount0 = FrameCount;
	}
}


int CFrameRate::GetRate(void)
{
	return FrameRate;
}


CFrameRate FPS;
//-----------------------------------------------------------------------------
// Name: InitD3D()
// Desc: Initializes Direct3D
//-----------------------------------------------------------------------------
HRESULT InitD3D( HWND hWnd )
{
    // Create the D3D object.
    if( NULL == ( g_pD3D = Direct3DCreate8( D3D_SDK_VERSION ) ) )
	{
		//MessageBox(NULL, "ARRRRRGGGGH", "Hi", MB_OK);
        return E_FAIL;
	}

    // Get the current desktop display mode, so we can set up a back
    // buffer of the same format
    D3DDISPLAYMODE d3ddm;
    if( FAILED( g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm ) ) )
	{
		//MessageBox(NULL, "ARRRRRGGGGH", "Hi", MB_OK);
        return E_FAIL;
	}

    // Set up the structure used to create the D3DDevice
    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory( &d3dpp, sizeof(d3dpp) );
	d3dpp.SwapEffect = D3DSWAPEFFECT_FLIP;
	d3dpp.Windowed = FALSE;
	d3dpp.BackBufferFormat = d3ddm.Format;
    d3dpp.BackBufferWidth = SCREEN_WIDTH;
	d3dpp.BackBufferHeight = SCREEN_HEIGHT;
	d3dpp.BackBufferCount = 1;
	d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
	d3dpp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
	d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
    
    // Create the D3DDevice
    if( FAILED( g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd,
                                      D3DCREATE_HARDWARE_VERTEXPROCESSING,
                                      &d3dpp, &g_pd3dDevice ) ) )
    {
		MessageBox(NULL, "The detected videocard does not support modern hardware vertex processing, attempting (ugly)software processing", "Hi", MB_OK);
        if(FAILED(g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_pd3dDevice )))
		{
			MessageBox(NULL, "Sorry, Your computer is retarded.", NULL, MB_OK);
			return E_FAIL;
		}
    }

    g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE);
	g_pd3dDevice->SetRenderState(D3DRS_SPECULARENABLE, true);


	HFONT hFont = CreateFont(28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, PROOF_QUALITY, 0, "Arial"); 	
	D3DXCreateFont(g_pd3dDevice, hFont, &g_pD3DXFont);  

    return S_OK;
}


//-----------------------------------------------------------------------------
// Name: InitGeometry()
// Desc: Creates the scene geometry
//-----------------------------------------------------------------------------
HRESULT InitGeometry()
{
    // Initialize three vertices for rendering a triangle
    CUSTOMVERTEX g_Vertices[(NumVertices + 2) + 6];
		
	D3DXCreateTextureFromFile( g_pd3dDevice, "earth.bmp", &g_pTexture );

	g_Vertices[0].position = D3DXVECTOR3(0.0f, 0.0f, -1.0f); 
	g_Vertices[0].diffuse = D3DCOLOR_XRGB(255,255,255);

	float i;
	int count = 1;
	for(i=0; i<=360.0f; i += (360.0f/(float)NumVertices))
	{
		g_Vertices[count].position = D3DXVECTOR3(COS360(i), SIN360(i), 0.2f * SIN360(i * 9.0f));
		g_Vertices[count].diffuse = D3DCOLOR_XRGB(255,255,255);
		
		g_Vertices[count].tu       = COS360(i);
        g_Vertices[count].tv       = SIN360(i);

		g_Vertices[count].specular = D3DCOLOR_XRGB(rand()%255,255,255);
		count++;
	}

	count = 0;
	for(i=0; i<362.0f; i += ((360.0f/(float)NumVertices)))
	{
		D3DXVec3Cross(&g_Vertices[count].normal, &g_Vertices[count].position, &g_Vertices[0].position); 
		count ++;
	}
	//D3DXVec3Cross(&g_Vertices[360].normal, &g_Vertices[360].position, &g_Vertices[0].position); 


	g_Vertices[NumVertices + 2].position = D3DXVECTOR3(-1.2f, 0.0f, 0.0f);
	g_Vertices[NumVertices + 2].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 2].normal   = D3DXVECTOR3(-1.2f, 0.0f, 1.0f);

	g_Vertices[NumVertices + 3].position = D3DXVECTOR3(1.2f, 0.0f, 0.0f);
	g_Vertices[NumVertices + 3].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 3].normal   = D3DXVECTOR3(1.2f, 0.0f, 0.0f);

	g_Vertices[NumVertices + 4].position = D3DXVECTOR3(0.0f, -1.2f, 0.0f);
	g_Vertices[NumVertices + 4].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 4].normal   = D3DXVECTOR3(0.0f, -1.2f, 1.0f);

	g_Vertices[NumVertices + 5].position = D3DXVECTOR3(0.0f, 1.2f, 0.0f);
	g_Vertices[NumVertices + 5].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 5].normal   = D3DXVECTOR3(0.0f, 1.2f, 1.0f);

	g_Vertices[NumVertices + 6].position = D3DXVECTOR3(0.0f, 0.0f, -1.2f);
	g_Vertices[NumVertices + 6].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 6].normal   = D3DXVECTOR3(0.0f, 0.0f, 1.2f);

	g_Vertices[NumVertices + 7].position = D3DXVECTOR3(0.0f, 0.0f, 1.2f);
	g_Vertices[NumVertices + 7].diffuse	= D3DCOLOR_XRGB(0,255,0);
	g_Vertices[NumVertices + 7].normal   = D3DXVECTOR3(0.0f, 0.0f, -1.2f);
	

    // Create the vertex buffer.
    if( FAILED( g_pd3dDevice->CreateVertexBuffer( (NumVertices + 2 + 6)*sizeof(CUSTOMVERTEX),
                                                  0, D3DFVF_CUSTOMVERTEX,
                                                  D3DPOOL_DEFAULT, &g_pVB ) ) )
    {
        return E_FAIL;
    }

    // Fill the vertex buffer.
    VOID* pVertices;
    if( FAILED( g_pVB->Lock( 0, sizeof(g_Vertices), (BYTE**)&pVertices, 0 ) ) )
        return E_FAIL;
    memcpy( pVertices, g_Vertices, sizeof(g_Vertices) );

    g_pVB->Unlock();



	if(FAILED(g_pd3dDevice->CreateVertexBuffer(3 * sizeof(CUSTOMVERTEX), 0, D3DFVF_CUSTOMVERTEX, D3DPOOL_DEFAULT, &g_pVB2)))
    {
        return E_FAIL;
    }
	
	CUSTOMVERTEX* Vertices;
    g_pVB2->Lock(0, 3 * sizeof(CUSTOMVERTEX),(BYTE**)&Vertices, 0 );
    
	Vertices[0].position = D3DXVECTOR3(0.0f, -1.0f, 0.0f);
	Vertices[0].diffuse    = D3DCOLOR_XRGB(255,255,255);
	Vertices[0].tu		 = 0.0f;
	Vertices[0].tv		 = -1.0f;
	Vertices[0].normal	 = D3DXVECTOR3(0.0f, 0.0f, 1.0f);

	Vertices[1].position = D3DXVECTOR3(-1.0f, 1.0f, 0.0f);
	Vertices[1].diffuse    = D3DCOLOR_XRGB(255,255,0);
	Vertices[1].tu		 = -1.0f;
	Vertices[1].tv		 = 1.0f;
	Vertices[1].normal	 = D3DXVECTOR3(0.0f, 0.0f, 1.0f);

	Vertices[2].position = D3DXVECTOR3(1.0f, 1.0f, 0.0f);
	Vertices[2].diffuse	 = D3DCOLOR_XRGB(0,255,0);
	Vertices[2].tu		 = 1.0f;
	Vertices[2].tv		 = 1.0f;
	Vertices[2].normal	 = D3DXVECTOR3(0.0f, 0.0f, 1.0f);


    g_pVB2->Unlock();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: Cleanup()
// Desc: Releases all previously initialized objects
//-----------------------------------------------------------------------------
VOID Cleanup()
{
    if( g_pVB != NULL )
        g_pVB->Release();

    if( g_pVB2 != NULL )
        g_pVB2->Release();

    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();

}



//-----------------------------------------------------------------------------
// Name: SetupMatrices()
// Desc: Sets up the world, view, and projection transform matrices.
//-----------------------------------------------------------------------------
VOID SetupMatrices()
{
    // For our world matrix, we will just rotate the object about the y-axis.
    D3DXMATRIX matWorld, matX, matY, matZ;
  	static float rx=0, ry=0, rz=0;

	if(KEY_DOWN(VK_UP))
	{
		rx++;
	}

	if(KEY_DOWN(VK_DOWN))
	{
		rx--;
	}

	if(KEY_DOWN(VK_RIGHT))
	{
		ry++;	
	}

	if(KEY_DOWN(VK_LEFT))
	{
		ry--;	
	}

	if(KEY_DOWN(88))
	{
		rz--;
	}

	if(KEY_DOWN(90))
	{
		rz++;
	}

	if(KEY_DOWN(VK_SUBTRACT) || KEY_DOWN(189))
	{
		VOID* pVertices;
		g_pVB->Lock( 0, (NumVertices + 8) * sizeof(CUSTOMVERTEX), (BYTE**)&pVertices, 0 );
		((CUSTOMVERTEX *)pVertices)[0].position.z -= .02f;
		g_pVB->Unlock();
	}

	if(KEY_DOWN(VK_ADD) || KEY_DOWN(187))
	{
		VOID* pVertices;
		g_pVB->Lock( 0, (NumVertices + 8) * sizeof(CUSTOMVERTEX), (BYTE**)&pVertices, 0 );
		((CUSTOMVERTEX *)pVertices)[0].position.z += .02f;
		g_pVB->Unlock();
	}

	if(KEY_DOWN(VK_SPACE))
	{
		static int count = 0;
		VOID* pVertices;
		g_pVB->Lock( 0, (NumVertices + 8) * sizeof(CUSTOMVERTEX), (BYTE**)&pVertices, 0 );
		((CUSTOMVERTEX *)pVertices)[0].position.z = 2 * SIN360(count);
		count+=2;
		g_pVB->Unlock();
	}

	if(KEY_DOWN(84))
	{
		if(!b_texture)
		{
			b_texture = 1;
		}
		else
		{
			b_texture = 0;
		}

		while(KEY_DOWN(84));
	}


	D3DXMatrixRotationX(&matX, rx * (float)RADIAN);
	D3DXMatrixRotationY(&matY, ry * (float)RADIAN);
	D3DXMatrixRotationZ(&matZ, rz * (float)RADIAN);

	rx=ry=rz=0;

	g_pd3dDevice->MultiplyTransform(D3DTS_WORLD, &matX);
	g_pd3dDevice->MultiplyTransform(D3DTS_WORLD, &matY);
	g_pd3dDevice->MultiplyTransform(D3DTS_WORLD, &matZ);
	//g_pd3dDevice->SetTransform(D3DTS_WORLD, &matX);
	
	
	D3DXMATRIX matView;
    D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 0.0f,-5.0f ),
                                  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ),
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
    g_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

 
    D3DXMATRIX matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, (D3DX_PI/4), 1152.0f/864.0f, 1.0f, 100.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}


VOID SetupMatrices2()
{
	static float count = 0;
	count++;
    D3DXMATRIX matWorld;
	D3DXMatrixRotationX(&matWorld, count * (float)RADIAN);
	g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld);
    
	
	D3DXMATRIX matView;
    D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 0.0f,-5.0f ),
                                  &D3DXVECTOR3( 0.0f, 0.0f, 0.0f ),
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
    g_pd3dDevice->SetTransform( D3DTS_VIEW, &matView );

 
	D3DXMATRIX matProj;
    D3DXMatrixPerspectiveFovLH( &matProj, (D3DX_PI/4), 1152.0f/864.0f, 1.0f, 100.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}



float lz = 0;
VOID SetupLights()
{
	static int count = 0;
    D3DMATERIAL8 mtrl;
    ZeroMemory( &mtrl, sizeof(D3DMATERIAL8) );
    mtrl.Diffuse.r = mtrl.Ambient.r = 1.0f;
    mtrl.Diffuse.g = mtrl.Ambient.g = 1.0f;
    mtrl.Diffuse.b = mtrl.Ambient.b = 1.0f;
    mtrl.Diffuse.a = mtrl.Ambient.a = 1.0f;
    g_pd3dDevice->SetMaterial( &mtrl );

    D3DXVECTOR3 vecDir;
    D3DLIGHT8 light;
    ZeroMemory( &light, sizeof(D3DLIGHT8) );
    light.Type       = D3DLIGHT_POINT;
    light.Diffuse.r  = 1.4f;
    light.Diffuse.g  = 1.0f;
    light.Diffuse.b  = 3.0f;

	POINT mouse;
	GetCursorPos(&mouse);

	if(KEY_DOWN(67)) lz -= 1.0f;
	if(KEY_DOWN(86)) lz += 1.0f;

	light.Position = D3DXVECTOR3((float) (mouse.x - MID_X) -10, (float) (MID_Y - mouse.y), lz);
		//D3DXVECTOR3(3 * COS360(count), 3 * SIN360(count), 0);

	

	count++;

    vecDir = D3DXVECTOR3(-COS360(count), -SIN360(count), 0);
    D3DXVec3Normalize( (D3DXVECTOR3*)&light.Direction, &vecDir );
    light.Range       = 1000.0f;
    g_pd3dDevice->SetLight( 0, &light );
    g_pd3dDevice->LightEnable( 0, TRUE );
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, TRUE );

    // Finally, turn on some ambient light.
    g_pd3dDevice->SetRenderState( D3DRS_AMBIENT, 0x00020202);
}


//-----------------------------------------------------------------------------
// Name: Render()
// Desc: Draws the scene
//-----------------------------------------------------------------------------
VOID Render()
{
    // Clear the backbuffer to a black color
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(50,50,50), 1.0f, 0 );

    // Begin the scene
    g_pd3dDevice->BeginScene();

	SetupLights();
    /*
    g_pd3dDevice->SetStreamSource( 0, g_pVB2, sizeof(CUSTOMVERTEX) );
    SetupMatrices2();
	g_pd3dDevice->SetVertexShader( D3DFVF_CUSTOMVERTEX );
	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 1);
*/


	g_pd3dDevice->SetStreamSource(0, g_pVB, sizeof(CUSTOMVERTEX) );



    SetupMatrices();
	g_pd3dDevice->SetVertexShader( D3DFVF_CUSTOMVERTEX );

	if(b_texture)
	{
		g_pd3dDevice->SetTexture( 0, g_pTexture );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
		
	}

	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLEFAN, 0, NumVertices);
	
	g_pd3dDevice->DrawPrimitive( D3DPT_LINELIST, NumVertices + 2, 3);


	RECT rTemp = {0, 0, 1024, 400}; 	
	char msg[100];
	wsprintf(msg, "FPS: %d\nKEYS:   Arrows(z,x,left,right,up,down), Space Bar, +/-, Mouse, T(doesn't toggle)", FPS.GetRate());
	g_pD3DXFont->DrawText(msg, -1, &rTemp, DT_LEFT, D3DCOLOR_RGBA(255, 120, 120, 255));
	
    // End the scene
    g_pd3dDevice->EndScene();

	//g_D3DFont->DrawText(10, 10, 0x00ff0000, "Hello");
    // Present the backbuffer contents to the display
    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );

	FPS.CountFrames();
}




//-----------------------------------------------------------------------------
// Name: MsgProc()
// Desc: The window's message handler
//-----------------------------------------------------------------------------
LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch( msg )
    {
        case WM_DESTROY:
            PostQuitMessage( 0 );
            return 0;
    }

    return DefWindowProc( hWnd, msg, wParam, lParam );
}




//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: The application's entry point
//-----------------------------------------------------------------------------
INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
    // Register the window class
    WNDCLASSEX wc = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 0L,
                      GetModuleHandle(NULL), NULL, NULL, NULL, NULL,
                      "D3D Tutorial", NULL };
    RegisterClassEx( &wc );

    // Create the application's window
    HWND hWnd = CreateWindow( "D3D Tutorial", "D3D Tutorial 03: Matrices",
                              WS_OVERLAPPEDWINDOW, 100, 100, 256, 256,
                              GetDesktopWindow(), NULL, wc.hInstance, NULL );

    // Initialize Direct3D
    if( SUCCEEDED( InitD3D( hWnd ) ) )
    {
		
        // Create the scene geometry
        if( SUCCEEDED( InitGeometry() ) )
        {
            // Show the window
            ShowWindow( hWnd, SW_SHOWDEFAULT );
            UpdateWindow( hWnd );

			ShowCursor(0);

            // Enter the message loop
            MSG msg;
            ZeroMemory( &msg, sizeof(msg) );
            while( msg.message!=WM_QUIT )
            {
                if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
                {
                    TranslateMessage( &msg );
                    DispatchMessage( &msg );
                }
                else
				{
                    Render();
					if(KEY_DOWN(VK_ESCAPE)) PostMessage(hWnd, WM_QUIT, 0, 0);
				}
            }
        }
    }

    // Clean up everything and exit the app
    Cleanup();
    UnregisterClass( "D3D Tutorial", wc.hInstance );
    return 0;
}



